<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ApiProductdetailModel extends BaseModel {
    protected $table      = 'api_productdetail';
    protected $primaryKey = 'id';

	protected $allowedFields = ['api_code','api_partnumber','pdf_dir','del_flg'];

    protected $returnType = 'App\Entities\ApiProductdetail';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'api_code' => 'required',
        'api_partnumber' => 'required|min_length[2]',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableApiProductdetail = $this::getTableName();
         return $this->where('id', esc($id))->select("$tableApiProductdetail.*")->first();
    }

    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];
        $tableApiProductdetail = $this::getTableName();
        $queryBuilder = $this->where("$tableApiProductdetail.del_flg", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableApiProductdetail.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableApiProductdetail.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['api_partnumber']) && $this->checkSearchItem($condition['api_partnumber'])){
            $queryBuilder->like("$tableApiProductdetail.api_partnumber", trim($condition['api_partnumber']));
        }

        $queryBuilder->select("$tableApiProductdetail.*");

        if(!isset($limit)) $limit = 20;
        
        if($allData){
            $dataResult = $queryBuilder->findAll($limit);
            return $dataResult;
        }

        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }

    public function getSearch($condition = [], $limit = 20){
        $tableApiProductdetail = $this::getTableName();
        $queryBuilder = $this->where("$tableApiProductdetail.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['api_partnumber'])){
            $queryBuilder->like("$tableApiProductdetail.api_partnumber", esc($condition['api_partnumber']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableApiProductdetail.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableApiProductdetail.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableApiProductdetail.created_at desc");
        $queryBuilder->select("$tableApiProductdetail.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function updateProducts(){
        $updateSql = 'UPDATE products t1, api_productdetail t2 SET t1.pdf_dir = t2.pdf_dir, t1.updated_at = NOW() WHERE t1.product_api_id = t2.api_partnumber';

        $this->db->query($updateSql);
    }

    public function insertPndata(){
        
        $this->db->query('truncate `api_pndetaildata`');
        $insertSql = 'INSERT INTO api_pndetaildata (`api_code`, `api_partnumber`, `active_flg`, `created_at`, `updated_at`) SELECT `api_code`, `product_api_id`, 0, NOW(), NOW() FROM products';
        $this->db->query($insertSql);
    
    }

}