<?php
namespace App\Models;

use App\Entities\AppInfo;

class AppInfoModel extends BaseModel {
    protected $table      = 'app_info';
    protected $primaryKey = 'app_id';

    protected $allowedFields = ['app_name','app_src_icon','app_tel','app_fax','app_email','app_address','app_address_google_map'];

    protected $returnType = 'App\Entities\AppInfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function fistInfo(){
        $appInfo = $this->first();
        if(!isset($appInfo)) $appInfo = new AppInfo();
        return $appInfo;
    }
}