<?php
namespace App\Models;

use App\Helpers\DateHelper;

class CartPartinfoModel extends BaseModel {
    protected $table      = 'carts_partinfo';
    protected $primaryKey = 'inquiry_id';

    protected $allowedFields = ['inquiry_code','member_id','part_sequence','category3_code','part_number','name','qty','price','leadtime','purchase_price','amount','stock_location','delivery_code','check_flg','active_flg','del_flg'];

    protected $returnType = 'App\Entities\CartPartinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'inquiry_code'      => 'required',
        'part_number'       => 'required',
        'name'              => 'required',
        'qty'               => 'required',
        'price'             => 'required'
    ];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);

        /*
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        */

        $dataResult = $this->executePaginate($queryBuilder);

        return $dataResult;
    }

    public function getPartinfo($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');

        //$builder->where('name', $name);
        //$builder->where('title', $title);
        //$builder->where('status', $status);
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getBuyPartinfo($inquiry_code, $inquiry_id_array){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->whereIn('inquiry_id', $inquiry_id_array);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');

        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getChkPartinfo($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('check_flg', 1);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getBuyNowPartinfo($inquiry_code,$inquiry_id){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('inquiry_id', $inquiry_id);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getPartinfoCount($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }

    public function containedPart($inquiry_code, $part_sequence){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('part_sequence', $part_sequence);
        // $queryBuilder = $this->countAllResults();
        // $queryBuilder = $this->findAll();
        $queryBuilder = $this->orderBy('created_at desc');


        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function deleteInquiryId($inquiry_id){
        $this->delete(['inquiry_id' => $inquiry_id]);
    }

    public function offByCheckFlg($inquiry_code){
        $queryBuilder = $this->set('check_flg', '0');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->update();
     }


     public function updateIdActiveFlg($inquiry_code, $inquiryids){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('inquiry_id', $inquiryids);
        $queryBuilder = $this->update();
     }



     public function containedtUpqty($inquiry_code, $inquiry_id, $upqty, $price){
        $queryBuilder = $this->set('qty', $upqty);
        $queryBuilder = $this->set('price', $price);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('inquiry_id', $inquiry_id);
        $queryBuilder = $this->update();
     }


    public function updateByActiveFlg($inquiry_code){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->update();
     }

    public function getCartpartinfo($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('created_at desc');

        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function findByInquiryId($inquiry_id){
        $tableInquiry = $this::getTableName();
        return $this->where('inquiry_id', esc($inquiry_id))->select("$tableInquiry.*")->first();
    }

    /// 카트 모달용
    public function get_all_carts() {
        $query = $this->db->query('select * from carts_partinfo');
         return $query->getResult();
     }
  
     public function get_by_id($id) {
       //$sql = 'select * from carts_partinfo where inquiry_id ='.$id ;
       //$query =  $this->db->query($sql); 
       //return $query->getRow();

     }
  
     public function cart_add($data) {
          
         $query = $this->db->table($this->table)->insert($data);
         
         return $this->db->insertID();
     }
  
     public function cart_update($where, $data) {
         $this->db->table($this->table)->update($data, $where);
         return $this->db->affectedRows();
     }
  
     public function delete_by_id($id) {
         $this->db->table($this->table)->delete(array('inquiry_id' => $id)); 
     }

}