<?php
namespace App\Models;

use App\Helpers\DateHelper;

class Categorylevel3Model extends BaseModel {
    protected $table      = 'categorylevel3';
    protected $primaryKey = 'categorylevel3_id';

    protected $allowedFields = ['categorylevel2_id', 'categorylevel3_code', 'categorylevel2_code', 'categorylevel3_name', 'categorylevel3_name_eng', 'categorylevel3_name_eng', 'tariff_rate', 'margin_rate', 'active_flg', 'del_flg'];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    public function findByCategoryCode($category_category3_code){
        return $this->where('categorylevel3_code', $category_category3_code)->first();
    }

    public function findByCategoryName($categorylevel3_name){
        return $this->where('categorylevel3_name', $categorylevel3_name)->first();
    }

    public function findByCategoryInfo($categorylevel3_name_eng){
        return $this->where('categorylevel3_name_eng', $categorylevel3_name_eng)->first();
    }

    public function getCategory3List($category_category2_code){
        return $this->where('categorylevel2_code', $category_category2_code)->findAll();
    }

}