<?php
namespace App\Models;

use App\Helpers\DateHelper;

class DigikeyApiPndataModel extends BaseModel {
    protected $table      = 'digikeyapi_pndata';
    protected $primaryKey = 'id';
    
    protected $allowedFields = ['api_code','maker_partnumber','active_flg'];

    protected $returnType = 'App\Entities\DigikeyApiPndata';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

public function getDigikeyApiId($api_code){
    $queryBuilder = $this->where('active_flg', 0);
    $queryBuilder = $this->like('api_code', $api_code);
    $queryBuilder = $this->select("maker_partnumber");
    $queryBuilder = $this->findAll();
    
    return $queryBuilder;
}

public function findByProductSeq($product_api_id){
    $tableProduct = ProductModel::getTableName();
    return $this->where('product_api_id', esc($product_api_id))->select("$tableProduct.maker_seq")->first();
}

public function updateActiveFlg($maker_partnumber){
    $queryBuilder = $this->set('active_flg', '1');
    $queryBuilder = $this->where('maker_partnumber', $maker_partnumber);
    $queryBuilder = $this->update();
 }


}
