<?php
namespace App\Models;

use App\Helpers\DateHelper;

class DigikeyApiProductinfoModel extends BaseModel {
    protected $table      = 'digikeyapi_productinfo';
    protected $primaryKey = 'id';

	protected $allowedFields = [ 'api_code','part_category2','part_category3','dk_pn','manufacturer','manufacturer_pn','brief_description','description','image_dir','pdf_dir','api_flg','packing_code','packsize','price','qty','moq','active_flg','price1','mini_qty1','price2','mini_qty2','price3','mini_qty3','price4','mini_qty4','price5','mini_qty5','price6','mini_qty6','del_flg'];

    protected $returnType = 'App\Entities\DigikeyApiProductinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'api_code' => 'required',
        'manufacturer_pn' => 'required|min_length[2]',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableDigikeyApiProductinfo = $this::getTableName();
         return $this->where('id', esc($id))->select("$tableDigikeyApiProductinfo.*")->first();
    }

    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];
        $tableDigikeyApiProductinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableDigikeyApiProductinfo.del_flg", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableDigikeyApiProductinfo.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableDigikeyApiProductinfo.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['manufacturer_pn']) && $this->checkSearchItem($condition['manufacturer_pn'])){
            $queryBuilder->like("$tableDigikeyApiProductinfo.manufacturer_pn", trim($condition['manufacturer_pn']));
        }

        $queryBuilder->select("$tableDigikeyApiProductinfo.*");

        if(!isset($limit)) $limit = 20;
        
        if($allData){
            $dataResult = $queryBuilder->findAll($limit);
            return $dataResult;
        }

        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }

    public function getSearch($condition = [], $limit = 20){
        $tableDigikeyApiProductinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableDigikeyApiProductinfo.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['manufacturer_pn'])){
            $queryBuilder->like("$tableDigikeyApiProductinfo.manufacturer_pn", esc($condition['manufacturer_pn']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableDigikeyApiProductinfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableDigikeyApiProductinfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableDigikeyApiProductinfo.created_at desc");
        $queryBuilder->select("$tableDigikeyApiProductinfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


}