<?php
namespace App\Models;

use App\Helpers\DateHelper;

class DisplayinfoModel extends BaseModel {
    protected $table      = 'display_info';
    protected $primaryKey = 'id';

	protected $allowedFields = ['display_code', 'display_id', 'display_flg', 'display_name', 'display_file_dir', 'display_type', 'display_number', 'manufacturer_id', 'active_flg','del_flg'];

    protected $returnType = 'App\Entities\Displayinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'display_code' => 'required',
        'display_name' => 'required',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableDisplayinfo = $this::getTableName();
        return $this->where('id', esc($id))->select("$tableDisplayinfo.*")->first();
    }
    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableDisplayinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableDisplayinfo.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['display_name'])){
            $queryBuilder->like("$tableDisplayinfo.display_name", esc($condition['display_name']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableDisplayinfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableDisplayinfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableDisplayinfo.created_at desc");
        $queryBuilder->select("$tableDisplayinfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}