<?php
namespace App\Models;

use App\Helpers\DateHelper;

class EstimateModel extends BaseModel {
    protected $table      = 'estimate';
    protected $primaryKey = 'id';

    protected $allowedFields = ['estimate_code','title','category_id','situation','item_code','part_number','manufacturer_name','member_code','user_name','user_email','replyemeil_chk','user_phone','password','content','answer_content','hit_number','public_flg','account_manager_id','active_flg','answer_created_at','del_flg'];

    protected $returnType = 'App\Entities\Estimate';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'title' => 'required|min_length[5]',
        'content' => 'required',
    ];


    protected $validationMessages = [];
    protected $skipValidation     = true;


    public function findInfoById($id){
        $tableEstimate = $this::getTableName();
        return $this->where('id', esc($id))->select("$tableEstimate.*")->first();
    }

    /*
    public function findInfoById($id){
        $tableEstimate = $this::getTableName();
        $tableCategory = EstimateCategoryModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableEstimate.category_id = $tableCategory.category_id")
            ->select("$tableEstimate.* , $tableCategory.category_name")->first();
    }
    */

    public function getSearch($condition = [], $limit = 20){
        $tableEstimateCategory = EstimateCategoryModel::getTableName();
        $tableEstimate = $this::getTableName();
        $queryBuilder = $this->where("$tableEstimate.del_flg", DELETE_FLG_OFF);
        
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableEstimate.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableEstimate.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableEstimate.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableEstimate.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->select("$tableEstimate.*");
        $queryBuilder->orderBy('created_at desc');


        if(!isset($limit)) $limit = 20;

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchMem($condition = [], $limit = 20){
        $tableEstimateCategory = EstimateCategoryModel::getTableName();
        $tableEstimate = $this::getTableName();
        $queryBuilder = $this->where("$tableEstimate.del_flg", DELETE_FLG_OFF);
        $queryBuilder = $this->where("$tableEstimate.member_code", $condition['member_code']);

        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableEstimate.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableEstimate.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableEstimate.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableEstimate.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->select("$tableEstimate.*");
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchMemCount($condition = [],$situation){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('member_code', $condition['member_code']);
        $queryBuilder = $this->where('situation', $situation);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where('category_id', esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like('title', esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }

    public function estimate_add($data) {
        $tableEstimate = $this::getTableName();
        $query = $this->table($tableEstimate)->insert($data);
        
        return $this->insertID();
    }

}