<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ExchangeCounrtyModel extends BaseModel {
    protected $table      = 'exchange_counrty';
    protected $primaryKey = 'id';

	protected $allowedFields = ['counrty_code','counrty_kor_name','counrty_eng_name','active_flg','del_flg'];

    protected $returnType = 'App\Entities\Locationinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'counrty_code' => 'required',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableLocationinfo = $this::getTableName();
         return $this->where('id', esc($id))->select("$tableLocationinfo.*")->first();
    }

    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableLocationinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableLocationinfo.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['counrty_kor_name'])){
            $queryBuilder->like("$tableLocationinfo.counrty_kor_name", esc($condition['counrty_kor_name']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableLocationinfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableLocationinfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableLocationinfo.created_at desc");
        $queryBuilder->select("$tableLocationinfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}