<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ExchangeInfoModel extends BaseModel {
    protected $table      = 'exchange_rate';
    protected $primaryKey = 'id';

    protected $allowedFields = ['counrty_code', 'standard_amount','del_flg'];

    protected $returnType = 'App\Entities\ExchangeInfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';


    protected $validationRules    = [
        'standard_amount' => 'required'
    ];

    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getSearch($condition = [], $limit = 20){

        $sch_date = $condition['to_date'];
        $str_date = strtotime($sch_date.'+1 days');
        $date_string = date("Y-m-d H:i:s", $str_date);
        //var_dump($date_string);
        //exit;

        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($date_string)));
        }

        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getInfo(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder->orderBy('created_at desc');
        return $this->executePaginate($queryBuilder, 1);
    }

    public function deleteOld(){
        $deleteOldSql = 'delete from `exchange_rate` WHERE `created_at` <= date_sub(curdate(), INTERVAL 365 day)';
        $this->db->query($deleteOldSql);
    }
}