<?php
namespace App\Models;

use App\Helpers\DateHelper;

class InquiryPartinfoModel extends BaseModel {
    protected $table      = 'inquiries_partinfo';
    protected $primaryKey = 'inquiry_id';

    protected $allowedFields = ['inquiry_code','member_id','part_sequence','category3_code','part_number','name','qty','price','purchase_price','amount','stock_location','delivery_code','check_flg','active_flg','del_flg'];

    protected $returnType = 'App\Entities\InquiryPartinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'inquiry_code'      => 'required',
        'part_number'       => 'required',
        'name'              => 'required',
        'qty'               => 'required',
        'price'             => 'required'
    ];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);

        /*
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        */

        $dataResult = $this->executePaginate($queryBuilder);

        return $dataResult;
    }

    public function getPartinfo($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');

        //$builder->where('name', $name);
        //$builder->where('title', $title);
        //$builder->where('status', $status);
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getChkPartinfo($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('check_flg', 1);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getPartinfoCount($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->countAllResults();


        //var_dump($queryBuilder);
        //exit;
        return $queryBuilder;

        //$dataResult = $this->executePaginate($queryBuilder);
        //return $dataResult;
    }

    public function deleteInquiryId($inquiry_id){
        $this->delete(['inquiry_id' => $inquiry_id]);
    }

    public function offByCheckFlg($inquiry_code){
        $queryBuilder = $this->set('check_flg', '0');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->update();
     }

     public function updateIdActiveFlg($inquiry_code, $inquiryids){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('inquiry_id', $inquiryids);
        $queryBuilder = $this->update();
     }

    public function updateByActiveFlg($inquiry_code){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->update();
     }

    public function getInquirypartinfo($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('created_at desc');

        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function findByInquiryId($inquiry_id){
        $tableInquiry = $this::getTableName();
        return $this->where('inquiry_id', esc($inquiry_id))->select("$tableInquiry.*")->first();
    }

    public function inquiry_update($where, $data) {
        $this->db->table($this->table)->update($data, $where);
        return $this->db->affectedRows();
    }
 

}