<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ItemsCollectModel extends BaseModel {
    protected $table      = 'itemsCollect';
    protected $primaryKey = 'seq_id';

    protected $allowedFields = ['item_id','item_number','category_id1','category_name1','category_id2','category_name2','manufacturer_id','manufacturer_name','package','title','mpn','quantity','whs_js','whs_zh','whs_hk',
    'moq','order_multiple','weight','packaging','sell_unit','packing_num','packing_unit','prices0_min_qty','prices0_max_qty','prices0_currency','prices0_price','prices1_min_qty','prices1_max_qty','prices1_currency',
    'prices1_price','prices2_min_qty','prices2_max_qty','prices2_currency','prices2_price','prices3_min_qty','prices3_max_qty','prices3_currency','prices3_price','prices4_min_qty','prices4_max_qty','prices4_currency',
    'prices4_price','prices5_min_qty','prices5_max_qty','prices5_currency','prices5_price','datasheet_pdf','images0','images1','images2','rohs','description','isPreSale','del_flg'];

    protected $returnType = 'App\Entities\ItemsCollect';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = '';

    protected $validationRules    = [];
    protected $validationMessages = [];

    protected $skipValidation     = true;

    public function getSearch($limit = 20, $level1_id){
        $tableItemsCollect = $this::getTableName();

        $queryBuilder = $this->where("$tableItemsCollect.level1_id", $level1_id);
        if(isset($condition['level1_id']) && $this->checkSearchItem($condition['level1_id'])){
            $queryBuilder->like("$tableItemsCollect.level1_id", esc($condition['level1_id']));
        }
        $queryBuilder->select("$tableItemsCollect.*");
        $queryBuilder->orderBy('lcreated_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


    public function getSearchtest($condition = [],$limit = 20, $level1_id){
        $tableItemsCollect = $this::getTableName();

        $queryBuilder = $this->where("$tableItemsCollect.level1_id", $level1_id);
        if(isset($condition['level1_name']) && $this->checkSearchItem($condition['level1_name'])){
            $queryBuilder->like("$tableItemsCollect.level1_name", esc($condition['level1_name']));
        }
        $queryBuilder->select("$tableItemsCollect.*");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    
    public function getAdmSearch($condition = [], $limit = 20){
        $tableItemsCollect = $this::getTableName();

        $queryBuilder = $this->where("$tableItemsCollect.del_flg", DELETE_FLG_OFF);
        if(isset($condition['level1_id']) && $this->checkSearchItem($condition['level1_id'])){
            $queryBuilder->like("$tableItemsCollect.level1_id", esc($condition['level1_id']));
        }
        if(isset($condition['level1_id']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableItemsCollect.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableItemsCollect.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->select("$tableItemsCollect.*");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


}