<?php
namespace App\Models;

use App\Helpers\DateHelper;

class LcscProductinfoModel extends BaseModel {
    protected $table      = 'lcsc_info';
    protected $primaryKey = 'id';

	protected $allowedFields = [ 'item_id','product_code','item_number','category_id1','category_name1','category_id2','category_name2','manufacturer_id','manufacturer_name','package','title','mpn','quantity','whs_js','whs_zh','whs_hk','moq','order_multiple','weight','packaging','sell_unit','packing_num','packing_unit',
    'prices0_min_qty','prices0_max_qty','prices0_currency','prices0_price','prices1_min_qty','prices1_max_qty','prices1_currency','prices1_price','prices2_min_qty','prices2_max_qty','prices2_currency','prices2_price','prices3_min_qty','prices3_max_qty','prices3_currency','prices3_price','prices4_min_qty','prices4_max_qty',
    'prices4_currency','prices4_price','prices5_min_qty','prices5_max_qty','prices5_currency','prices5_price','datasheet_pdf','images0','images1','images2','rohs','description','isPreSale','active_flg','del_flg'];

    protected $returnType = 'App\Entities\LcscProductinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'item_id' => 'required',
        'mpn' => 'required|min_length[2]',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableLcscProductinfo = $this::getTableName();
         return $this->where('id', esc($id))->select("$tableLcscProductinfo.*")->first();
    }

    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];
        $tableLcscProductinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableLcscProductinfo.del_flg", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableLcscProductinfo.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableLcscProductinfo.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['mpn']) && $this->checkSearchItem($condition['mpn'])){
            $queryBuilder->like("$tableLcscProductinfo.mpn", trim($condition['mpn']));
        }

        $queryBuilder->select("$tableLcscProductinfo.*");

        if(!isset($limit)) $limit = 20;
        
        if($allData){
            $dataResult = $queryBuilder->findAll($limit);
            return $dataResult;
        }

        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }

    public function getSearch($condition = [], $limit = 20){
        $tableLcscProductinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableLcscProductinfo.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['mpn'])){
            $queryBuilder->like("$tableLcscProductinfo.mpn", esc($condition['mpn']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableLcscProductinfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableLcscProductinfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableLcscProductinfo.created_at desc");
        $queryBuilder->select("$tableLcscProductinfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function eraseTempProducts(){
        return $this->db->query('truncate `lcsc_info`'); 
    }


    public function insertLcscinfo($text){
        $insertSql = 'INSERT INTO lcsc_info (`item_id`,`item_number`,`category_id1`,`category_name1`,`category_id2`,`category_name2`,`manufacturer_id`,`manufacturer_name`,`package`,`title`,`mpn`,`quantity`,`whs_js`,`whs_zh`,`whs_hk`, 
                    `moq`,`order_multiple`,`weight`,`packaging`,`sell_unit`,`packing_num`,`packing_unit`,`prices0_min_qty`,`prices0_max_qty`,`prices0_currency`,`prices0_price`,`prices1_min_qty`,`prices1_max_qty`,`prices1_currency`,`prices1_price`, 
                    `prices2_min_qty`,`prices2_max_qty`,`prices2_currency`,`prices2_price`,`prices3_min_qty`,`prices3_max_qty`,`prices3_currency`,`prices3_price`,`prices4_min_qty`,`prices4_max_qty`,`prices4_currency`,`prices4_price`,`prices5_min_qty`, 
                    `prices5_max_qty`,`prices5_currency`,`prices5_price`,`datasheet_pdf`,`images0`,`images1`,`images2`,`rohs`,`description`,`isPreSale`,`active_flg`,`del_flg`,`created_at`,`updated_at`) VALUES $text, 0, NOW(), NOW()';

        $this->db->query($insertSql);
    }
    
    public function updateCategoryCode($id, $product_code){
        $queryBuilder = $this->set('product_code', $product_code);
        $queryBuilder = $this->where('id', $id);
        $queryBuilder = $this->update();
    }

    public function insertProductInfo($exchange_rat){
        $insertSql = 'INSERT INTO products (`product_code`,`part_category`,`part_category2`,`maker_seq`,`maker_name`,`part_number`,`part_number_sequence`,`search_word`,`brief_description`,`image_dir`,`delivery_code`,`api_flg`,`api_code`,`product_api_id`,`qty`,`packing_code`,`leadtime`,`moq`,`in_moq`,`mpq`,`stock_location`,
        `selling_price1`,`prices_price1`,`prices_currency1`,`unit_mini_quantity1`,`unit_max_quantity1`,`selling_price2`,`prices_price2`,`prices_currency2`,`unit_mini_quantity2`,`unit_max_quantity2`,`selling_price3`,`prices_price3`,`prices_currency3`,`unit_mini_quantity3`,`unit_max_quantity3`,
        `selling_price4`,`prices_price4`,`prices_currency4`,`unit_mini_quantity4`,`unit_max_quantity4`,`selling_price5`,`prices_price5`,`prices_currency5`,`unit_mini_quantity5`,`unit_max_quantity5`,`selling_price6`,`prices_price6`,`prices_currency6`,`unit_mini_quantity6`,`unit_max_quantity6`,`virtualpn`,
        `created_at`,`updated_at`) SELECT `product_code`,`categorylevel1_code`,`categorylevel2_code`,`maker_seq`,CONCAT(manufacturer_name),CONCAT(mpn),CONCAT(manufacturer_name,mpn),`item_number`,CONCAT(title,"|^|",description),`images0`,1,1,"LC",`item_number`,`quantity`,`packaging_code`,2,`moq`,`moq`,`moq`,3,
        (`prices0_price`*1.15)*'.$exchange_rat.',`prices0_price`,`prices0_currency`,`prices0_min_qty`,`prices0_max_qty`,(`prices1_price`*1.15)*'.$exchange_rat.',`prices1_price`,`prices1_currency`,`prices1_min_qty`,`prices1_max_qty`,(`prices2_price`*1.15)*'.$exchange_rat.',`prices2_price`,`prices2_currency`,`prices2_min_qty`,`prices2_max_qty`,
        (`prices3_price`*1.15)*'.$exchange_rat.',`prices3_price`,`prices3_currency`,`prices3_min_qty`,`prices3_max_qty`,(`prices4_price`*1.15)*'.$exchange_rat.',`prices4_price`,`prices4_currency`,`prices4_min_qty`,`prices4_max_qty`,(`prices5_price`*1.15)*'.$exchange_rat.',`prices5_price`,`prices5_currency`,`prices5_min_qty`,`prices5_max_qty`,
        CONCAT(mpn,product_code,manufacturer_name),NOW(), NOW() FROM lcsc_info WHERE `active_flg` = 0';
        $this->db->query($insertSql);

        $insertDetailSql = 'INSERT INTO products_detail (`product_code`,`api_flg`,`api_code`,`product_api_id`,`product_doc`,`product_image1`,`product_image2`,`product_pdf`,`created_at`,`updated_at`) SELECT `product_code`,1,"LC",`item_number`,`description`,`images1`,`images2`,`datasheet_pdf`, NOW(), NOW() FROM lcsc_info WHERE `active_flg` = 0';
        $this->db->query($insertDetailSql);

        $insertUpActiveSql = 'UPDATE `lcsc_info` SET `active_flg` = 1';
        $this->db->query($insertUpActiveSql);
    }

    public function replaceProductInfo(){

        $replaceSql01 = "update products set virtualpn = replace(virtualpn, '[`~!#$%^&*|\\\'\";:\/?]', '')";
        $this->db->query($replaceSql01);

        $replaceSql02 = "update products set virtualpn = replace(virtualpn, '-', '')";
        $this->db->query($replaceSql02);

        $replaceSql03 = "update products set virtualpn = replace(virtualpn, '/', '')";
        $this->db->query($replaceSql03);

        $replaceSql04 = "update products set virtualpn = replace(virtualpn, ' ', '')";
        $this->db->query($replaceSql04);

        $replaceSql05 = "update products set virtualpn = replace(virtualpn, '#', '')";
        $this->db->query($replaceSql05);

        $replaceSql06 = "update products set virtualpn = replace(virtualpn, '*', '')";
        $this->db->query($replaceSql06);

        $replaceSql07 = "update products set virtualpn = replace(virtualpn, ',', '')";
        $this->db->query($replaceSql07);

    }

    public function insertSeqdata(){
        // $this->db->query('truncate `api_pndata`');
        $insertSql = 'INSERT INTO api_pndata (`api_code`, `api_partnumber`, `active_flg`, `created_at`, `updated_at`) SELECT "LC", `item_number`, 0, NOW(), NOW() FROM lcsc_info';
        $this->db->query($insertSql);
    }
    
}