<?php
namespace App\Models;

use App\Helpers\DateHelper;

class LocationinfoModel extends BaseModel {
    protected $table      = 'location_info';
    protected $primaryKey = 'id';

	protected $allowedFields = ['location_code','location_kor_name','location_eng_name','active_flg','del_flg'];

    protected $returnType = 'App\Entities\Locationinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'location_code' => 'required',
        'location_kor_name' => 'required|min_length[2]',
        'location_eng_name' => 'required',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableLocationinfo = $this::getTableName();
       // $tableCategory = LocationinfoCategoryModel::getTableName();
       // $tableAccountManager = AccountManagerModel::getTableName();

        return $this->where('id', esc($id))->select("$tableLocationinfo.*")->first();
    }

    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableLocationinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableLocationinfo.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['location_kor_name'])){
            $queryBuilder->like("$tableLocationinfo.location_kor_name", esc($condition['location_kor_name']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableLocationinfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableLocationinfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableLocationinfo.created_at desc");
        $queryBuilder->select("$tableLocationinfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}