<?php
namespace App\Models;

class ManufacturerModel extends BaseModel {
    protected $table      = 'manufacturers';
    protected $primaryKey = 'maker_seq';

    protected $allowedFields = ['maker_code','name','manufacturer_link','manufacturer_content','manufacturer_image_dir','manufacturer_logo_dir','del_flg'];

    protected $returnType = 'App\Entities\Manufacturer';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'maker_code' => 'required',
        'name' => 'required|min_length[2]',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function findByCode($manufactureCode){
        return $this->where('del_flg', DELETE_FLG_OFF)->where('maker_code', $manufactureCode)->first();
    }

    public function findById($manufactureId){
        return $this->where('del_flg', DELETE_FLG_OFF)->where('maker_seq', $manufactureId)->first();
    }

    public function findByManufactureId($manufacturerNames){
        return $this->where('del_flg', DELETE_FLG_OFF)->where('name', $manufacturerNames)->first();
    }

    public function findAllByCode($manufacturerCodes){
        if(!is_array($manufacturerCodes)) $manufacturerCodes = [$manufacturerCodes];
        return $this->where('del_flg', DELETE_FLG_OFF)->whereIn('maker_code', $manufacturerCodes)->findAll();
    }

    public function findAllByName($manufacturerNames){
        if(!is_array($manufacturerNames)) $manufacturerNames = [$manufacturerNames];
        return $this->where('del_flg', DELETE_FLG_OFF)->whereIn('name', $manufacturerNames)->findAll();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableManufacturer = $this::getTableName();
        $queryBuilder = $this->where("$tableManufacturer.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['name'])){
            $queryBuilder->like("$tableManufacturer.name", esc($condition['name']));
        }

        $queryBuilder->orderBy("$tableManufacturer.created_at desc");
        $queryBuilder->select("$tableManufacturer.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchAll($condition = []){
        $tableManufacturer = $this::getTableName();
        $queryBuilder = $this->where("$tableManufacturer.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['name'])){
            $queryBuilder->like("$tableManufacturer.name", esc($condition['name']));
        }

        $queryBuilder->orderBy("$tableManufacturer.name asc");
        $queryBuilder->select("$tableManufacturer.*");

        if(!isset($limit)) $limit = 20000;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByCharacter($character){
        $tableManufacturer = $this::getTableName();
        //if(!is_array($character)) $character = [$character];
        return $this->where("$tableManufacturer.del_flg", DELETE_FLG_OFF,true)->like("$tableManufacturer.name", $character, 'after')->orderBy("$tableManufacturer.name asc")->findAll();
    }

    public function getSearchExl($limit){
        if(!isset($condition)) $condition = [];
        $tableManufacturer = $this::getTableName();
        $queryBuilder = $this->where("$tableManufacturer.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['name'])){
            $queryBuilder->like("$tableManufacturer.name", esc($condition['name']));
        }

        $queryBuilder->select("$tableManufacturer.*");
        $queryBuilder->orderBy("$tableManufacturer.created_at desc");
        
        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }
    
}
