<?php
namespace App\Models;

class MemberFileModel extends BaseModel {
    protected $table      = 'member_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['members_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\MemberFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;
//    protected $createdField  = 'created_at';
//    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findMembersFile($membersId, $fileNo){
        return $this->where('file_no', $fileNo)->where('members_id', $membersId)->first();
    }
}