<?php
namespace App\Models;

class NewFileModel extends BaseModel {
    protected $table      = 'new_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['news_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\NewFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;
//    protected $createdField  = 'created_at';
//    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findNewsFile($newsId, $fileNo){
        return $this->where('file_no', $fileNo)->where('news_id', $newsId)->first();
    }
}