<?php
namespace App\Models;

use App\Helpers\DateHelper;

class NewModel extends BaseModel {
    protected $table      = 'news';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title','category_id','content','hit_number','account_manager_id','public_flg','del_flg'];

    protected $returnType = 'App\Entities\News';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'category_id' => 'required',
        'title' => 'required|min_length[5]',
        'content' => 'required',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableNews = $this::getTableName();
        $tableCategory = NewCategoryModel::getTableName();
        $tableAccountManager = AccountManagerModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableNews.category_id = $tableCategory.category_id")
            ->join($tableAccountManager,"$tableAccountManager.account_id = $tableNews.account_manager_id")
            ->select("$tableNews.* , $tableCategory.category_name , $tableAccountManager.full_name")->first();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableNewsCategory = NewCategoryModel::getTableName();
        $tableNews = $this::getTableName();
        $tableAccountManager = AccountManagerModel::getTableName();
        $queryBuilder = $this->where("$tableNews.del_flg", DELETE_FLG_OFF);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableNews.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableNews.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableNews.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableNews.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->join($tableNewsCategory,"$tableNewsCategory.category_id = $tableNews.category_id");
        $queryBuilder->join($tableAccountManager,"$tableAccountManager.account_id = $tableNews.account_manager_id");
        $queryBuilder->select("$tableNews.* , $tableNewsCategory.category_name , $tableAccountManager.full_name");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}