<?php
namespace App\Models;

class NoticeFileModel extends BaseModel {
    protected $table      = 'notice_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['notice_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\NoticeFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findNoticeFile($noticesId, $fileNo){
        return $this->where('file_no', $fileNo)->where('notice_id', $noticesId)->first();
    }
}