<?php
namespace App\Models;

use App\Helpers\DateHelper;

class NoticeModel extends BaseModel {
    protected $table      = 'notice';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title','category_id','top_flg','content','hit_number','public_flg','account_manager_id','del_flg'];

    protected $returnType = 'App\Entities\Notice';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';


    protected $validationRules    = [
        'category_id' => 'required',
        'title' => 'required|min_length[5]',
        'content' => 'required',
    ];


    protected $validationMessages = [];
    protected $skipValidation     = true;

    /*
    // 관리자 정보 사용
    public function findInfoById($id){
        $tableNotice = $this::getTableName();
        $tableCategory = NoticeCategoryModel::getTableName();
        $tableAccountManager = AccountManagerModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableNotice.category_id = $tableCategory.category_id")
            ->join($tableAccountManager,"$tableAccountManager.account_id = $tableNotice.account_manager_id")
            ->select("$tableNotice.* , $tableCategory.category_name , $tableAccountManager.full_name")->first();
    }
    */

    public function findInfoById($id){
        $tableNotice = $this::getTableName();
        $tableCategory = NoticeCategoryModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableNotice.category_id = $tableCategory.category_id")
            ->select("$tableNotice.* , $tableCategory.category_name")->first();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableNoticeCategory = NoticeCategoryModel::getTableName();
        $tableNotice = $this::getTableName();
        // $tableAccountManager = AccountManagerModel::getTableName();
        $queryBuilder = $this->where("$tableNotice.del_flg", DELETE_FLG_OFF);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableNotice.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableNotice.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableNotice.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableNotice.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        // 관리자 정보 사용
        // $queryBuilder->join($tableNoticeCategory,"$tableNoticeCategory.category_id = $tableNotice.category_id");
        // $queryBuilder->join($tableAccountManager,"$tableAccountManager.account_id = $tableNotice.account_manager_id");
        // $queryBuilder->select("$tableNotice.* , $tableNoticeCategory.category_name , $tableAccountManager.full_name");
        // $queryBuilder->orderBy('created_at desc');

        $queryBuilder->join($tableNoticeCategory,"$tableNoticeCategory.category_id = $tableNotice.category_id");
        $queryBuilder->select("$tableNotice.* , $tableNoticeCategory.category_name");
        $queryBuilder->orderBy('created_at desc');


        if(!isset($limit)) $limit = 20;

        return $this->executePaginate($queryBuilder, $limit);
    }


}