<?php
namespace App\Models;

use App\Helpers\DateHelper;

class OrderPartinfoModel extends BaseModel {
    protected $table      = 'orders_partinfo';
    protected $primaryKey = 'order_id';

    protected $allowedFields = ['order_code','nav_productorder_code','order_type','order_status','member_code','item_code','category3_code','part_number','manufacturer_name','price','qty','modify_qty','supply_price',
    'vat','amount','stock_location','delivery_code','change_flg','before_price','before_qty','ship_method_flg','ship_code','ship_company','ship_date','invoice_num','cancel_reason','return_reason','return_deliv_cost',
    'orderchk_flg','active_flg','del_flg'];

    protected $returnType = 'App\Entities\OrderPartinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';


    protected $validationRules    = [
        'order_code'      => 'required',
        'part_number'     => 'required',
        'qty'             => 'required',
        'price'           => 'required'
    ];

    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $dataResult = $this->executePaginate($queryBuilder);

        return $dataResult;
    }

    public function getPartinfo($order_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('order_code', $order_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');

        //$builder->where('name', $name);
        //$builder->where('title', $title);
        //$builder->where('status', $status);
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getPartinfoCount($order_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('order_code', $order_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->countAllResults();
        //var_dump($queryBuilder);
        //exit;
        return $queryBuilder;
        //$dataResult = $this->executePaginate($queryBuilder);
        //return $dataResult;
    }

    public function deleteOrderId($order_id){
        $this->delete(['order_id' => $order_id]);
    }

    public function updateByActiveFlg($order_code){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('order_code', $order_code);
        $queryBuilder = $this->update();
     }

    public function updateByOrderCheckFlg($nav_productorder_code){
        $queryBuilder = $this->set('orderchk_flg', '1');
        $queryBuilder = $this->where('nav_productorder_code', $nav_productorder_code);
        $queryBuilder = $this->update();
     }

     public function npayOrderCancel($nav_productorder_code, $cancel_reason){
        $queryBuilder = $this->set('order_status', '9');
        $queryBuilder = $this->set('cancel_reason', $cancel_reason);
        $queryBuilder = $this->where('nav_productorder_code', $nav_productorder_code);
        $queryBuilder = $this->update();
     }

     public function npayOrderReason($nav_productorder_code, $return_deliv_cost, $return_reason){
        $queryBuilder = $this->set('order_status', '12');
        $queryBuilder = $this->set('return_reason', $return_reason);
        $queryBuilder = $this->set('return_deliv_cost', $return_deliv_cost);
        $queryBuilder = $this->where('nav_productorder_code', $nav_productorder_code);
        $queryBuilder = $this->update();
     }

    public function getOrderpartinfo($order_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('order_code', $order_code);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('created_at desc');
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function findByOrderId($order_id){
        $tableOrder = $this::getTableName();
        return $this->where('order_id', esc($order_id))->select("$tableOrder.*")->first();
    }

    public function autoStateChange05($day_7ago){
        $queryBuilder = $this->set('order_status', '8');
        $queryBuilder = $this->where('order_status', '5');
        $queryBuilder->where("ship_date <=", DateHelper::setFirstHourMinuteDate(esc($day_7ago)));
        $queryBuilder = $this->update();
     }

    public function autoStateChange06($day_7ago){
        $queryBuilder = $this->set('order_status', '8');
        $queryBuilder = $this->where('order_status', '6');
        $queryBuilder->where("ship_date <=", DateHelper::setFirstHourMinuteDate(esc($day_7ago)));
        $queryBuilder = $this->update();
     }

     public function updateStatus($order_code, $order_status){
        $queryBuilder = $this->set('order_status', $order_status);
        $queryBuilder = $this->where('order_code', $order_code);
        $queryBuilder = $this->update();
     }

     public function updateStatusId($order_id, $order_status){
        $queryBuilder = $this->set('order_status', $order_status);
        $queryBuilder = $this->where('order_id', $order_id);
        $queryBuilder = $this->update();
     }

     public function orderCount($order_code){
        $queryBuilder = $this->where('order_code', $order_code);
        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }

    public function orderStatusCount($order_code, $order_status){
        $queryBuilder = $this->where('order_code', $order_code);
        $queryBuilder = $this->where('order_status', $order_status);
        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }

}