<?php
namespace App\Models;

use App\Helpers\DateHelper;

class PartInquiryModel extends BaseModel {
    protected $table      = 'part_inquiries';
    protected $primaryKey = 'inquiry_id';

    protected $allowedFields = ['part_number','name','qty','price', 'name','email','tel','title','memo_content','del_flg'];

    protected $returnType = 'App\Entities\PartInquiry';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'part_number'       => 'required',
        'name' => 'required',
        'qty'               => 'required',
        'price'             => 'required',
        'name'              => 'required',
        'email'             => 'required|valid_email',
        'tel'               => 'required',
        'title'             => 'required',
        'memo_content'      => 'required'
    ];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByInquiryId($inquiry_id){
        $tableInquiry = $this::getTableName();
        return $this->where('inquiry_id', esc($inquiry_id))->select("$tableInquiry.*")->first();
    }

}