<?php
namespace App\Models;

class PopupFileModel extends BaseModel {
    protected $table      = 'popup_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['popups_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\PopupFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findPopupsFile($popupsId, $fileNo){
        return $this->where('file_no', $fileNo)->where('popups_id', $popupsId)->first();
    }
}