<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ProductQuoteModel extends BaseModel {
    protected $table      = 'sale_quotes';
    protected $primaryKey = 'id';

    protected $allowedFields = ['quote_no', 'member_id', 'quote_date' , 'total_qty','amount' , 'total_vat' , 'total_amount', 'quote_memo'];

    protected $returnType = 'App\Entities\ProductQuote';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch($condition = [], $limit = 20){
        $tableQuote = $this::getTableName();
        $tableMember = MemberModel::getTableName();
        $queryBuilder = $this->where("$tableQuote.del_flg", DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableQuote.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableQuote.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        if($this->checkSearchItem($condition['member_id'])){
            $queryBuilder->where("$tableQuote.member_id", esc($condition['member_id']));
        }
        $queryBuilder->join($tableMember,"$tableMember.member_id = $tableQuote.member_id");
        $queryBuilder->select("$tableQuote.* , $tableMember.member_name, $tableMember.member_email");
        $queryBuilder->orderBy("$tableQuote.quote_date desc , created_at desc");
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findInfoById($id){
        $tableQuote = $this::getTableName();
        $tableMember = MemberModel::getTableName();
        return $this->where('id', $id)->join($tableMember,"$tableMember.member_id = $tableQuote.member_id")
            ->select("$tableQuote.* , $tableMember.member_name, $tableMember.member_email")->first();
    }
}