<?php
namespace App\Models;

use App\Helpers\ArrayHelper;
use http\QueryString;

class ProductmpModel extends BaseModel {
    protected $table      = 'tmp_products';
    protected $primaryKey = 'product_id';
  
    protected $allowedFields = ['product_code','part_category','part_category2','part_category3','maker_seq','location_code','display_set','newproduct_chk','bestproduct_chk','recomproduct_chk','brandproduct_chk','event_set',
                                'part_number','part_number_sequence','search_word','brief_description','situation','exposure','description','product_related','date_code','image_dir','image2_dir','image3_dir','pdf_dir',
                                'delivery_code','api_flg','api_code','tariff_rate','product_api_id','qty','packing_code','packsize','price','leadtime','moq','mpq','stock_location','taxable',
                                'selling_price1','prices_price1','prices_currency1','margin_rate1','unit_mini_quantity1','unit_max_quantity1','selling_price2','prices_price2','prices_currency2','margin_rate2','unit_mini_quantity2','unit_max_quantity2',
                                'selling_price3','prices_price3','prices_currency3','margin_rate3','unit_mini_quantity3','unit_max_quantity3','selling_price4','prices_price4','prices_currency4','margin_rate4','unit_mini_quantity4','unit_max_quantity4',
                                'selling_price5','prices_price5','prices_currency5','margin_rate5','unit_mini_quantity5','unit_max_quantity5','selling_price6','prices_price6','prices_currency6','margin_rate6','unit_mini_quantity6','unit_max_quantity6',
                                'navershop_chk','navershop_status','qty_flag','virtualpn','active_flg','del_flg'];

    protected $returnType = 'App\Entities\Productmp';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /*
    protected $validationRules    = [
        'part_number' => 'required|min_length[3]',
        'qty' => 'required|alpha_numeric',
        'id' => 'required',
    ];
    */


    protected $validationMessages = [];
    protected $skipValidation     = true;

    /*
    public function save($data): bool{
        $data->part_number_sequence = strrev($data->part_number);
        return parent::save($data);
    }
    */

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];
        // var_dump($condition);

        $tableProduct = ProductmpModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();

        $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
        //$queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableProduct.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableProduct.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
            $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
        }

        $queryBuilder->select("$tableProduct.*");

//        var_dump($queryBuilder->getCompiledSelect());die();

        if(!isset($limit)) $limit = 20;
        if($allData){

//            $queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
//            $queryBuilder->select("$tableProduct.* , $tableManufacturer.maker_seq , $tableManufacturer.name");

            $dataResult = $queryBuilder->findAll($limit);
                    
            return $dataResult;
        }


        $dataResult = $this->executePaginate($queryBuilder, $limit);
 
    // MDI2020 test
    //var_dump($dataResult);

      if(count($dataResult['lists']) > 0){

      }

        return $dataResult;
    }

/******************************************************************************************/

public function getSearch($condition = [], $limit = 20 , $allData = false){

    if(!isset($condition)) $condition = [];
    
    //var_dump($condition);

    $tableProduct = ProductmpModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();
    $tableCategorylevel1 = Categorylevel1Model::getTableName();
    $tableCategorylevel2 = Categorylevel2Model::getTableName();
    $tableCategorylevel3 = Categorylevel3Model::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
        $queryBuilder->where("$tableProduct.created_at >=", esc($condition['from_date']));
    }
    if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
        $queryBuilder->where("$tableProduct.created_at <=", esc($condition['to_date']));
    }

    if(isset($condition['keyword']) && $this->checkSearchItem($condition['keyword'])){
            // And 검색
            //$queryBuilder-> where("$tableProduct.part_number", trim($condition['keyword']));
            //$queryBuilder-> where("$tableProduct.product_api_id", trim($condition['keyword']));

            // Join - Or 검색
            $queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
            $queryBuilder->join($tableCategorylevel1,"$tableCategorylevel1.categorylevel1_code = $tableProduct.part_category");
            $queryBuilder->join($tableCategorylevel2,"$tableCategorylevel2.categorylevel2_code = $tableProduct.part_category2");
            $queryBuilder->join($tableCategorylevel3,"$tableCategorylevel3.categorylevel3_code = $tableProduct.part_category3");

        if(isset($condition['search_code']) && $this->checkSearchItem($condition['search_code'])) {

            $keyword = preg_replace("/\s+/", "", $condition['keyword']);
            $queryBuilder->where("$tableProduct.part_category", trim($condition['search_code']));
            $queryBuilder->like("$tableProduct.part_number_sequence", trim($keyword));
            //$queryBuilder->like("$tableProduct.part_number_sequence", trim($condition['keyword']));

        } else {

            $queryBuilder->like("$tableProduct.part_number", trim($condition['keyword']));
            $queryBuilder->orlike("$tableProduct.product_code", trim($condition['keyword']));
            $queryBuilder->orlike("$tableProduct.product_api_id", trim($condition['keyword']));
            $queryBuilder->orlike("$tableManufacturer.name", trim($condition['keyword']));
            $queryBuilder->orlike("$tableCategorylevel1.categorylevel1_name", trim($condition['keyword']));
            $queryBuilder->orlike("$tableCategorylevel2.categorylevel2_name", trim($condition['keyword']));
            $queryBuilder->orlike("$tableCategorylevel3.categorylevel3_name", trim($condition['keyword']));
            
        }

    }


    //if(isset($condition['search_code']) && $this->checkSearchItem($condition['search_code'])){
       // $queryBuilder->like("$tableProduct.part_category", trim($condition['search_code']));
    //}

    if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
        $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
    }

    if(isset($condition['part_category']) && $this->checkSearchItem($condition['part_category'])){
        $queryBuilder->like("$tableProduct.part_category", trim($condition['part_category']));
    }
    
    if(isset($condition['part_category2']) && $this->checkSearchItem($condition['part_category2'])){
        $queryBuilder->like("$tableProduct.part_category2", trim($condition['part_category2']));
    }

    if(isset($condition['part_category3']) && $this->checkSearchItem($condition['part_category3'])){
        $queryBuilder->like("$tableProduct.part_category3", trim($condition['part_category3']));
    }

    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    } elseif($condition['sort'] == "hprice") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
    } elseif($condition['sort'] == "lprice") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
    } elseif($condition['sort'] == "brand") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
    } else {
        // $queryBuilder->orderBy("$tableProduct.created_at desc");
        // $queryBuilder->orderBy("rand()"); //랜덤 검색

        $queryBuilder->orderBy("$tableProduct.part_category DESC");
    }


//        var_dump($queryBuilder->getCompiledSelect());die();
    if(!isset($limit)) $limit = 20;
    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }


    $dataResult = $this->executePaginate($queryBuilder, $limit);

// MDI2020 test
//var_dump($dataResult);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        //var_dump($listManufacturer);
        //exit;
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

        //var_dump($product);
        //exit;
    }

  if(count($dataResult['lists']) > 0){

  }

    return $dataResult;
}

/******************************************************************************************/


public function getSearchExl($limit){

    if(!isset($condition)) $condition = [];
    // var_dump($condition);

    $tableProduct = ProductmpModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    //$queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    return $dataResult;
}

public function insertProducts(){

    $insql = 'insert into products (`product_code`, `part_category`, `part_category2`, `part_category3`, `maker_seq`, `location_code`, `display_set`, `newproduct_chk`, `bestproduct_chk`, `recomproduct_chk`, `brandproduct_chk`, `event_set`, 
    `part_number`, `part_number_sequence`, `search_word`, `brief_description`, `situation`, `exposure`, `product_related`, `date_code`, `image_dir`, `delivery_code`, `api_flg`, `api_code`, `tariff_rate`, 
    `product_api_id`, `qty`, `packing_code`, `packsize`, `price`, `leadtime`, `moq`, `in_moq`, `mpq`, `stock_location`, `taxable`, `selling_price1`, `prices_price1`, `prices_currency1`, `margin_rate1`, `unit_mini_quantity1`, 
    `unit_max_quantity1`, `selling_price2`, `prices_price2`, `prices_currency2`, `margin_rate2`, `unit_mini_quantity2`, `unit_max_quantity2`, `selling_price3`, `prices_price3`, `prices_currency3`, `margin_rate3`, `unit_mini_quantity3`, 
    `unit_max_quantity3`, `selling_price4`, `prices_price4`, `prices_currency4`, `margin_rate4`, `unit_mini_quantity4`, `unit_max_quantity4`, `selling_price5`, `prices_price5`, `prices_currency5`, `margin_rate5`, `unit_mini_quantity5`, 
    `unit_max_quantity5`, `selling_price6`, `prices_price6`, `prices_currency6`, `margin_rate6`, `unit_mini_quantity6`, `unit_max_quantity6`, `navershop_chk`, `navershop_status`, `qty_flag`, `virtualpn`, `active_flg`, `del_flg`, `created_at`, `updated_at`) SELECT `product_code`, 
    `part_category`, `part_category2`, `part_category3`, `maker_seq`, `location_code`, `display_set`, `newproduct_chk`, `bestproduct_chk`, `recomproduct_chk`, `brandproduct_chk`, `event_set`, `part_number`, `part_number_sequence`, `search_word`, `brief_description`, 
    `situation`, `exposure`, `product_related`, `date_code`, `image_dir`, `delivery_code`, `api_flg`, `api_code`, `tariff_rate`, `product_api_id`, `qty`, `packing_code`, `packsize`, `price`, `leadtime`, `moq`, `mpq`, `mpq`, `stock_location`, `taxable`, 
    `selling_price1`, `prices_price1`, `prices_currency1`, `margin_rate1`, `unit_mini_quantity1`, `unit_max_quantity1`, `selling_price2`, `prices_price2`, `prices_currency2`, `margin_rate2`, `unit_mini_quantity2`, `unit_max_quantity2`, 
    `selling_price3`, `prices_price3`, `prices_currency3`, `margin_rate3`, `unit_mini_quantity3`, `unit_max_quantity3`, `selling_price4`, `prices_price4`, `prices_currency4`, `margin_rate4`, `unit_mini_quantity4`, `unit_max_quantity4`, 
    `selling_price5`, `prices_price5`, `prices_currency5`, `margin_rate5`, `unit_mini_quantity5`, `unit_max_quantity5`, `selling_price6`, `prices_price6`, `prices_currency6`, `margin_rate6`, `unit_mini_quantity6`, `unit_max_quantity6`, 
    `navershop_chk`, `navershop_status`, `qty_flag`, `virtualpn`, `active_flg`, `del_flg`, `created_at`, `updated_at` from tmp_products a where !EXISTS (select 1 from products b where a.part_number_sequence = b.part_number_sequence)';

    $this->db->query($insql);


    $insql_detail = 'insert into products_detail (`product_code`, `api_flg`, `api_code`, `product_api_id`, `product_doc`, `product_image1`, `product_image2`, `product_pdf`, `active_flg`, `del_flg`, `created_at`, `updated_at`) SELECT `product_code`,`api_flg`, 
    `api_code`, `product_api_id`, `description`, `image2_dir`, `image3_dir`, `pdf_dir`, `active_flg`, `del_flg`, `created_at`, `updated_at` from tmp_products a where !EXISTS (select 1 from  products_detail b where a.product_code = b.product_code)';

    $this->db->query($insql_detail);

}


public function updateProducts(){
    $insql = 'UPDATE products a INNER JOIN tmp_products b ON a.part_number_sequence=b.part_number_sequence SET a.qty=b.qty, 
        a.selling_price1=b.selling_price1, a.prices_price1=b.prices_price1, a.prices_currency1=b.prices_currency1, a.margin_rate1=b.margin_rate1, a.unit_mini_quantity1=b.unit_mini_quantity1,	a.unit_max_quantity1=b.unit_max_quantity1,
        a.selling_price2=b.selling_price2, a.prices_price2=b.prices_price2, a.prices_currency2=b.prices_currency2, a.margin_rate2=b.margin_rate2, a.unit_mini_quantity2=b.unit_mini_quantity2,	a.unit_max_quantity2=b.unit_max_quantity2,
        a.selling_price3=b.selling_price3, a.prices_price3=b.prices_price3, a.prices_currency3=b.prices_currency3, a.margin_rate3=b.margin_rate3, a.unit_mini_quantity3=b.unit_mini_quantity3,	a.unit_max_quantity3=b.unit_max_quantity3,
        a.selling_price4=b.selling_price4, a.prices_price4=b.prices_price4, a.prices_currency4=b.prices_currency4, a.margin_rate4=b.margin_rate4, a.unit_mini_quantity4=b.unit_mini_quantity4,	a.unit_max_quantity4=b.unit_max_quantity4,
        a.selling_price5=b.selling_price5, a.prices_price5=b.prices_price5, a.prices_currency5=b.prices_currency5, a.margin_rate5=b.margin_rate5, a.unit_mini_quantity5=b.unit_mini_quantity5,	a.unit_max_quantity5=b.unit_max_quantity5,
        a.selling_price6=b.selling_price6, a.prices_price6=b.prices_price6, a.prices_currency6=b.prices_currency6, a.margin_rate6=b.margin_rate6, a.unit_mini_quantity6=b.unit_mini_quantity6,	a.unit_max_quantity6=b.unit_max_quantity6';

    $this->db->query($insql);
    //return $this->db->query('truncate `tmp_products`'); 

}

public function updatApiProducts($api_code){
    $insql = 'UPDATE products a INNER JOIN tmp_products b ON a.product_api_id=b.product_api_id SET a.qty=b.qty, 
        a.selling_price1=b.selling_price1, a.prices_price1=b.prices_price1, a.prices_currency1=b.prices_currency1, a.margin_rate1=b.margin_rate1, a.unit_mini_quantity1=b.unit_mini_quantity1, a.unit_max_quantity1=b.unit_max_quantity1,
        a.selling_price2=b.selling_price2, a.prices_price2=b.prices_price2, a.prices_currency2=b.prices_currency2, a.margin_rate2=b.margin_rate2, a.unit_mini_quantity2=b.unit_mini_quantity2, a.unit_max_quantity2=b.unit_max_quantity2,
        a.selling_price3=b.selling_price3, a.prices_price3=b.prices_price3, a.prices_currency3=b.prices_currency3, a.margin_rate3=b.margin_rate3, a.unit_mini_quantity3=b.unit_mini_quantity3, a.unit_max_quantity3=b.unit_max_quantity3,
        a.selling_price4=b.selling_price4, a.prices_price4=b.prices_price4, a.prices_currency4=b.prices_currency4, a.margin_rate4=b.margin_rate4, a.unit_mini_quantity4=b.unit_mini_quantity4, a.unit_max_quantity4=b.unit_max_quantity4,
        a.selling_price5=b.selling_price5, a.prices_price5=b.prices_price5, a.prices_currency5=b.prices_currency5, a.margin_rate5=b.margin_rate5, a.unit_mini_quantity5=b.unit_mini_quantity5, a.unit_max_quantity5=b.unit_max_quantity5,
        a.selling_price6=b.selling_price6, a.prices_price6=b.prices_price6, a.prices_currency6=b.prices_currency6, a.margin_rate6=b.margin_rate6, a.unit_mini_quantity6=b.unit_mini_quantity6, a.unit_max_quantity6=b.unit_max_quantity6 
        where b.api_code ="'.$api_code.'"';

    $this->db->query($insql);
    //return $this->db->query('truncate `tmp_products`');     
}

/*
public function updateLCProducts(){
    $insql = 'UPDATE products a INNER JOIN tmp_products b ON a.product_api_id=b.product_api_id SET a.qty=b.qty';
    $this->db->query($insql);
    //return $this->db->query('truncate `tmp_products`'); 
}

public function updateICKProducts(){
    $insql = 'UPDATE products a INNER JOIN tmp_products b ON a.product_api_id=b.product_api_id SET a.qty=b.qty';
    $this->db->query($insql);
    //return $this->db->query('truncate `tmp_products`'); 
}
*/

public function eraseTempProducts(){
    return $this->db->query('truncate `tmp_products`'); 
}

/******************************************************************************************/


public function getProduct($condition, $limit = 20 , $allData = false){

    if(!isset($condition)) $condition = [];

    $tableProduct = ProductmpModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if($condition['product_sctype'] == "newproduct") {
        $queryBuilder->like("$tableProduct.newproduct_chk", trim('1'));
    } elseif($condition['product_sctype'] == "bestproduct") {
        $queryBuilder->like("$tableProduct.bestproduct_chk", trim('1'));
    } elseif($condition['product_sctype'] == "brandproduct") {
        $id = $condition['id'];
        $queryBuilder->where("$tableProduct.maker_seq", trim($id));
    } elseif($condition['product_sctype'] == "eventproduct") {
        $id = $condition['id'];
        $queryBuilder->where("$tableProduct.event_set", trim($id));
    } else {

    }

    $queryBuilder->select("$tableProduct.*");

    // echo  $condition['product_sctype'];
    // echo  '<br>';
    // echo  $condition['sort'];

    if($condition['sort'] == "recent") {
        $queryBuilder->orderBy("$tableProduct.created_at desc");

    } elseif($condition['sort'] == "hprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");

    } elseif($condition['sort'] == "lprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");

    } elseif($condition['sort'] == "brand") {
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");

    } else {
        $queryBuilder->orderBy("$tableProduct.created_at desc");

    }

    if(!isset($limit)) $limit = 20;
    if($allData){

        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }


    $dataResult = $this->executePaginate($queryBuilder, $limit);

// MDI2020 test
//var_dump($dataResult);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        //var_dump($listManufacturer);
        //exit;
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

        //var_dump($product);
        //exit;
    }

  if(count($dataResult['lists']) > 0){

  }

    return $dataResult;
}


/**** 2020-12-05 ***********/
public function getCategorySearch($condition = [], $condition2 = [], $limit = 20 , $allData = false){
    if(!isset($condition)) $condition = [];
    if(!isset($condition2)) $condition2 = [];

    $tableProduct = ProductmpModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();
    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if(isset($condition2['category']) && $this->checkSearchItem($condition2['category'])){
        $queryBuilder->where("$tableProduct.part_category", trim($condition2['category']));
    }

    if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
        $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number'])); //검색어 포함 검색
        //$queryBuilder->where("$tableProduct.part_number", trim($condition['part_number'])); //검색어만 검색
    }

        
	// MDI2020 test
    // var_dump($condition2);
    // var_dump($condition);

    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    } elseif($condition['sort'] == "hprice") {
        //var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
    } elseif($condition['sort'] == "lprice") {
        //var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
    } elseif($condition['sort'] == "brand") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
    } else {
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    }

    if(!isset($limit)) $limit = 20;

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;
                }
            }
        }
    }

    return $dataResult;
}

    public function findByProductId($productId){
        $tableProduct = ProductmpModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('product_id', esc($productId));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }


    public function findByProductCode($productCode){
        $tableProduct = ProductmpModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('product_code', esc($productCode));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    /**
     * @param string $partNumber
     * @return ProductmpModel|null
     */
    public function findByPartNumber($partNumber){
        $tableProduct = ProductmpModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('part_number', esc($partNumber));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    public function getByPartNumber($partNumber){
        if(!is_array($partNumber)) $partNumber = [$partNumber];
        $result = [];
        foreach (array_chunk($partNumber, 10000) as $partNumberIds){
            $resultProduct = $this->where('del_flg', DELETE_FLG_OFF)
                ->whereIn('part_number', $partNumberIds)->findAll();
            $result = array_merge($result, $resultProduct);
        }
        return $result;

    }

    public function getByProductNo($productIds){
        if(!is_array($productIds)) $productIds = [$productIds];
        $result = [];
        foreach (array_chunk($productIds, 10000) as $partProductIds){
            $resultProduct = $this->where('del_flg', DELETE_FLG_OFF)
                ->whereIn('product_id', $partProductIds)->findAll();
            $result = array_merge($result, $resultProduct);
        }
        return $result;

    }

    public function findInfo($productId){
        $tableProduct = ProductmpModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where("$tableProduct.del_flg", DELETE_FLG_OFF)->where("$tableProduct.product_id", $productId);
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    public function findByProductInfo($part_sequence){
        return $this->where('product_code', $part_sequence)->first();
    }


/******* Main Info Start *******************************************************************/

public function getRecommended($condition, $limit = 10 , $allData = false){

    $tableProduct = ProductmpModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    if(!isset($limit)) $limit = 10;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/


/******* Main Info Start *******************************************************************/

public function getBestproduct($condition, $limit = 10 , $allData = false){

    $tableProduct = ProductmpModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    if(!isset($limit)) $limit = 10;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/


/******* Main Info Start *******************************************************************/

public function getSelectproduct($condition, $limit, $allData = false){

    $tableProduct = ProductmpModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);
    // $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    if ($condition == "new") {
    $queryBuilder->like("$tableProduct.newproduct_chk", trim('1'));
    }

    $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    if(!isset($limit)) $limit = 5;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/


/******* Main Info Start *******************************************************************/

public function getBrandproduct($condition, $limit, $allData = false){

    $tableProduct = ProductmpModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->where("$tableProduct.maker_seq", trim($condition));

    $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    if(!isset($limit)) $limit = 3;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/

}