<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ProductsShippingModel extends BaseModel {
    protected $table      = 'products_shipping';
    protected $primaryKey = 'id';

    protected $allowedFields = ['product_code','shipping_add','location','shipping_method','free_shipping','cash_delivery','delivery_codes','shipping_show','active_flg','del_flg'];

    protected $returnType = 'App\Entities\ProductsShipping';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'product_code'      => 'required',
        'shipping_add'       => 'required'
    ];

    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $dataResult = $this->executePaginate($queryBuilder);

        return $dataResult;
    }

    public function getProductsshipping($product_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('product_code', $product_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');

        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getProductsshippingCount($product_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('product_code', $product_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->countAllResults();

        return $queryBuilder;

    }

    public function deleteProductsshippingId($id){
        $this->delete(['id' => $id]);
    }

    public function updateByActiveFlg($product_code){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('product_code', $product_code);
        $queryBuilder = $this->update();
     }

    public function findByProductsshippingId($id){
        $tableProductsshipping = $this::getTableName();
        return $this->where('id', esc($id))->select("$tableProductsshipping.*")->first();
    }

    public function uploadProductShipping($id, RequestInterface $request){

    }

}