<?php
namespace App\Models;

class ReasonreturnInfoModel extends BaseModel {
    protected $table      = 'reasonreturn_info';
    protected $primaryKey = 'return_id';

    protected $allowedFields = ['return_info','return_info_eng','active_flg','del_flg'];

    protected $returnType = 'App\Entities\ReasonreturnInfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'return_info' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getSearch($condition = [], $limit = 20){
        $tableReasonreturnInfo = $this::getTableName();
        $queryBuilder = $this->where("$tableReasonreturnInfo.del_flg", DELETE_FLG_OFF);
        if(isset($condition['return_info']) && $this->checkSearchItem($condition['return_info'])){
            $queryBuilder->like("$tableReasonreturnInfo.return_info", esc($condition['return_info']));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByCategoryInfo($return_info){
        return $this->where('return_info', $return_info)->first();
    }
}