<?php
namespace App\Models;

use App\Helpers\DateHelper;

class RefundPartinfoModel extends BaseModel {
    protected $table      = 'refunds_partinfo';
    protected $primaryKey = 'refund_id';

    protected $allowedFields = ['refund_code','refund_type','refund_reason','refund_status','order_id','order_code','member_code','item_code','category3_code',
    'part_number','manufacturer_name','price','qty','supply_price','vat','amount','stock_location','delivery_code','change_flg','before_price','before_qty',
    'ship_method_flg','ship_company','invoice_num','active_flg','del_flg'];

    protected $returnType = 'App\Entities\RefundPartinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /*
    protected $validationRules    = [
        'refund_code'      => 'required',
        'part_number'     => 'required',
        'qty'             => 'required',
        'price'           => 'required'
    ];
    */
    
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $dataResult = $this->executePaginate($queryBuilder);

        return $dataResult;
    }

    public function getPartinfo($refund_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('refund_code', $refund_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');

        //$builder->where('name', $name);
        //$builder->where('title', $title);
        //$builder->where('status', $status);
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getPartinfoCount($refund_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('refund_code', $refund_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->countAllResults();
        //var_dump($queryBuilder);
        //exit;
        return $queryBuilder;
        //$dataResult = $this->executePaginate($queryBuilder);
        //return $dataResult;
    }

    public function deleteRefundId($refund_id){
        $this->delete(['refund_id' => $refund_id]);
    }

    /*
    public function updateByActiveFlg($refund_code){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('refund_code', $refund_code);
        $queryBuilder = $this->update();
     }

    public function getRefundpartinfo($refund_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('refund_code', $refund_code);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('created_at desc');

        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }
    */

    public function updateStatus($refund_id, $refund_code, $refund_type, $refund_reason){
        $queryBuilder = $this->set('refund_status', '1');
        $queryBuilder = $this->set('refund_type', $refund_type);
        $queryBuilder = $this->set('refund_reason', $refund_reason);
        $queryBuilder = $this->where('refund_id', $refund_id);
        $queryBuilder = $this->where('refund_code', $refund_code);
        $queryBuilder = $this->update();
     }

    public function findByRefundId($refund_id){
        $tableRefund = $this::getTableName();
        return $this->where('refund_id', esc($refund_id))->select("$tableRefund.*")->first();
    }

}