<?php
namespace App\Models;

class ReviewFileModel extends BaseModel {
    protected $table      = 'review_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['review_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\ReviewFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findReviewFile($reviewsId, $fileNo){
        return $this->where('file_no', $fileNo)->where('review_id', $reviewsId)->first();
    }
}