<?php
namespace App\Models;

use App\Helpers\DateHelper;

class SearchTodayModel extends BaseModel {
	protected $table = 'search_today';
	protected $primaryKey = 'id';
	protected $allowedFields = ['word','count','del_flg'];

    protected $returnType = 'App\Entities\SearchToday';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getKeywordCount($search_keyword){
        $queryBuilder = $this->where('word', $search_keyword);
        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }

    public function findKeywordInfo($search_keyword){
        $tableSearchToday = $this::getTableName();
        return $this->where('word', esc($search_keyword))->select("$tableSearchToday.*")->first();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableSearchToday = $this::getTableName();
        $queryBuilder = $this->where("$tableSearchToday.del_flg", DELETE_FLG_OFF);

        if(isset($condition['word']) && $this->checkSearchItem($condition['word'])){
            $queryBuilder->like("$tableSearchToday.word", esc($condition['word']));
        }
        if(isset($condition['word']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableSearchToday.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableSearchToday.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->select("$tableSearchToday.*");
        $queryBuilder->orderBy('count desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}
