<?php
namespace App\Services;

use App\Entities\BannermainFile;
use App\Entities\Bannermains;
use App\Helpers\FileHelper;
use App\Models\BannermainModel;
use CodeIgniter\HTTP\RequestInterface;

class BannermainsService extends BaseService {
    public function saveBannermains(RequestInterface $request,$loginId){
        //Save bannermains
        $bannermains = new Bannermains();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['active_flg'] = get_public_id($inputs['active_flg']);
        $inputs['account_manager_id'] = $loginId;
        $bannermains->fill($inputs);
        // var_dump ($bannermains);
        // exit;
        $insertId = $this->bannermainsModel->insert($bannermains, true);

        if($insertId > 0){
            $bannermainDb = $this->bannermainsModel->find($insertId);
            $fileImage = $request->getFile('image_file');

            if(isset($fileImage) && !empty($fileImage->getClientName())){
                $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATH_UPLOAD_BANNERMAIN, $insertId);
                $bannermainDb->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                $this->bannermainsModel->save($bannermainDb);
            }

        }
    }

    public function updateBannermains($id, RequestInterface $request){
        $bannermainsItem = $this->bannermainsModel->find($id);

        if(isset($bannermainsItem)){
            $inputs = $request->getPost();
            $inputs['active_flg'] = get_public_id($inputs['active_flg']);
             $bannermainsItem->fill($inputs);
            
            $fileImage = $request->getFile('image_file');
            if(isset($fileImage)){
                $fileName = $fileImage->getClientName();
                if(isset($fileName) && !empty($fileName)){
                    FileHelper::deleteFile( $bannermainsItem->image_dir);
                    $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATH_UPLOAD_BANNERMAIN, $id);
                     $bannermainsItem->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                }
                
                $this->bannermainsModel->save($bannermainsItem);
            }

            $this->db->transComplete();
        }

    }

    public function deleteBannermains($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->bannermainsModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->bannermainsModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}