<?php
namespace App\Services;

use App\Entities\DeferredpayFile;
use App\Entities\Deferredpay;
use App\Helpers\FileHelper;
use App\Models\DeferredpayModel;
use CodeIgniter\HTTP\RequestInterface;

class DeferredpayService extends BaseService {
    // public function saveDeferredpay(RequestInterface $request,$loginId){
    public function saveDeferredpay(RequestInterface $request){
        //Save deferredpay
        $deferredpay = new Deferredpay();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['account_manager_id'] = $loginId;
        $deferredpay->fill($inputs);
        //var_dump ($deferredpay);
        //exit;
        $insertId = $this->deferredpayModel->insert($deferredpay, true);
        if($insertId > 0){
            $files = $request->getFiles();;
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $deferredpayFile = new DeferredpayFile([
                            'deferredpay_id' => esc($insertId),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->deferredpayFileModel->save($deferredpayFile);
                    }
                }
            }
        }
    }

    public function updateDeferredpay($id, RequestInterface $request){
        $deferredpayItem = $this->deferredpayModel->find($id);
        if(isset($deferredpayItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $deferredpayItem->fill($inputs);

            $this->deferredpayModel->save($deferredpayItem);
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $deferredpayFile = new DeferredpayFile([
                            'deferredpay_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->deferredpayFileModel->save($deferredpayFile);
                    }
                }
            }
        }
    }

    public function deleteDeferredpay($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->deferredpayModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->deferredpayModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}