<?php
namespace App\Services;

use App\Entities\DeliverycodeFile;
use App\Entities\Deliverycodes;
use App\Helpers\FileHelper;
use App\Models\DeliverycodeModel;
use CodeIgniter\HTTP\RequestInterface;

class DeliverycodesService extends BaseService {
    public function saveDeliverycodes(RequestInterface $request){
        //Save deliverycodes
        $deliverycodes = new Deliverycodes();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $deliverycodes->fill($inputs);

        $insertId = $this->deliverycodesModel->insert($deliverycodes, true);
    }

    public function updateDeliverycodes($id, RequestInterface $request){
        $deliverycodesItem = $this->deliverycodesModel->find($id);
        if(isset($deliverycodesItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $deliverycodesItem->fill($inputs);

            $this->deliverycodesModel->save($deliverycodesItem);
        }
    }

    public function deleteDeliverycodes($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->deliverycodesModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->deliverycodesModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}