<?php
namespace App\Services;

use App\Entities\DigikeyApiProductinfo;
use App\Helpers\FileHelper;
use App\Models\DigikeyApiProductinfoModel;
use CodeIgniter\HTTP\RequestInterface;

class DigikeyApiProductinfoService extends BaseService {

    public function saveDigikeyApiProductinfo(RequestInterface $request,$loginId){
        //Save digikeyApiProductinfo
        $digikeyApiProductinfo = new DigikeyApiProductinfo();
        $inputs = $request->getPost();
        $digikeyApiProductinfo->fill($inputs);
        //var_dump ($digikeyApiProductinfo);
        //exit;
        $this->digikeyApiProductinfoModel->insert($digikeyApiProductinfo, true);
    }

    public function updateDigikeyApiProductinfo($id, RequestInterface $request){
 
        $digikeyApiProductinfoItem = $this->digikeyApiProductinfoModel->find($id);
        if(isset($digikeyApiProductinfoItem)){
            $inputs = $request->getPost();
            $digikeyApiProductinfoItem->fill($inputs);
            $this->digikeyApiProductinfoModel->save($digikeyApiProductinfoItem);
            //exit;
        }
    }

    public function deleteDigikeyApiProductinfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->digikeyApiProductinfoModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->digikeyApiProductinfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}