<?php
namespace App\Services;

use App\Entities\EstimateFile;
use App\Entities\Estimate;
use App\Helpers\FileHelper;
use App\Models\EstimateModel;
use CodeIgniter\HTTP\RequestInterface;

class EstimateService extends BaseService {
    // public function saveEstimate(RequestInterface $request,$loginId){
    public function saveEstimate(RequestInterface $request){
        //Save estimate
        $estimate = new Estimate();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['account_manager_id'] = $loginId;
        $estimate->fill($inputs);
        //var_dump ($estimate);
        //exit;
        $insertId = $this->estimateModel->insert($estimate, true);
        if($insertId > 0){
            $files = $request->getFiles();;
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $estimateFile = new EstimateFile([
                            'estimate_id' => esc($insertId),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->estimateFileModel->save($estimateFile);
                    }
                }
            }
        }
    }

    public function updateEstimate($id, RequestInterface $request){
        $estimateItem = $this->estimateModel->find($id);
        //var_dump ($estimateItem);
        //exit;

        if(isset($estimateItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $estimateItem->fill($inputs);

            $this->estimateModel->save($estimateItem);
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $estimateFile = new EstimateFile([
                            'estimate_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->estimateFileModel->save($estimateFile);
                    }
                }
            }
        }
    }

    public function deleteEstimate($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->estimateModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->estimateModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}