<?php
namespace App\Services;

use App\Entities\ExchangeInfo;
use App\Helpers\FileHelper;
use App\Models\ExchangeInfoModel;
use CodeIgniter\HTTP\RequestInterface;

class ExchangeInfoService extends BaseService {
    public function saveExchangeInfo(RequestInterface $request){
        //Save exchangeInfo
        $exchangeInfo = new ExchangeInfo();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        
        $exchangeInfo->fill($inputs);
        //var_dump ($exchangeInfo);
        //exit;
        $insertId = $this->exchangeInfoModel->insert($exchangeInfo, true);
        
    }

    public function updateExchangeInfo($id, RequestInterface $request){
        $exchangeInfoItem = $this->exchangeInfoModel->find($id);

        if(isset($exchangeInfoItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $exchangeInfoItem->fill($inputs);

            $this->exchangeInfoModel->save($exchangeInfoItem);

            /*
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $exchangeInfoFile = new ExchangeInfoFile([
                            'exchangeInfo_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->newFileModel->save($exchangeInfoFile);
                    }
                }
            }
            */
        }
    }

    public function deleteExchangeInfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->exchangeInfoModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->exchangeInfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}