<?php
namespace App\Services;

use App\Entities\Manufacturer;
use App\Helpers\FileHelper;
use App\Models\ManufacturerModel;
use CodeIgniter\HTTP\RequestInterface;

class ManufacturerService extends BaseService {
    
    public function saveManufacturer(RequestInterface $request){
        //Save manufacturer
        $manufacturer = new Manufacturer();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $manufacturer->fill($inputs);
        $this->manufacturerModel->insert($manufacturer, true);
    }

    public function updateManufacturer($id, RequestInterface $request){
 
        $manufacturerItem = $this->manufacturerModel->find($id);
        if(isset($manufacturerItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $manufacturerItem->fill($inputs);

            $this->manufacturerModel->save($manufacturerItem);
            //exit;
        }
    }

    public function deleteManufacturer($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->manufacturerModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->manufacturerModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}