<?php
namespace App\Services;

use App\Entities\NewFile;
use App\Entities\News;
use App\Helpers\FileHelper;
use App\Models\NewModel;
use CodeIgniter\HTTP\RequestInterface;

class MemberService extends BaseService {

    public function deleteMember($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->memberModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->memberModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

    public function acceptMember($ids, $active_flg = MEMBER_ACCEPT_ON){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->memberModel->find($id);
                    if(isset($item)){
                        $item->active_flg = $active_flg;
                        $this->memberModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}