<?php
namespace App\Services;

use App\Entities\One2oneFile;
use App\Entities\One2one;
use App\Helpers\FileHelper;
use App\Models\One2oneModel;
use CodeIgniter\HTTP\RequestInterface;

class One2oneService extends BaseService {
    // public function saveOne2one(RequestInterface $request,$loginId){
    public function saveOne2one(RequestInterface $request){
        //Save one2one
        $one2one = new One2one();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['account_manager_id'] = $loginId;
        $one2one->fill($inputs);
        //var_dump ($one2one);
        //exit;
        $insertId = $this->one2oneModel->insert($one2one, true);
        if($insertId > 0){
            $files = $request->getFiles();;
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $one2oneFile = new One2oneFile([
                            'one2one_id' => esc($insertId),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->one2oneFileModel->save($one2oneFile);
                    }
                }
            }
        }
    }

    public function updateOne2one($id, RequestInterface $request){
        $one2oneItem = $this->one2oneModel->find($id);
        if(isset($one2oneItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $one2oneItem->fill($inputs);

            $this->one2oneModel->save($one2oneItem);
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $one2oneFile = new One2oneFile([
                            'one2one_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->one2oneFileModel->save($one2oneFile);
                    }
                }
            }
        }
    }

    public function deleteOne2one($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->one2oneModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->one2oneModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}