<?php
namespace App\Services;

use App\Entities\PopupFile;
use App\Entities\Popups;
use App\Helpers\FileHelper;
use App\Models\PopupModel;
use CodeIgniter\HTTP\RequestInterface;

class PopupsService extends BaseService {
    public function savePopups(RequestInterface $request,$loginId){
        //Save popups
        $popups = new Popups();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['active_flg'] = get_public_id($inputs['active_flg']);
        $inputs['account_manager_id'] = $loginId;
        $popups->fill($inputs);
        // var_dump ($popups);
        // exit;
        $insertId = $this->popupsModel->insert($popups, true);

        if($insertId > 0){
            $popupDb = $this->popupsModel->find($insertId);
            $fileImage = $request->getFile('image_file');

            if(isset($fileImage) && !empty($fileImage->getClientName())){
                $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATH_UPLOAD_POPUP, $insertId);
                $popupDb->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                $this->popupsModel->save($popupDb);
            }

        }
    }

    public function updatePopups($id, RequestInterface $request){
        $popupsItem = $this->popupsModel->find($id);

        if(isset($popupsItem)){
            $inputs = $request->getPost();
            $inputs['active_flg'] = get_public_id($inputs['active_flg']);
             $popupsItem->fill($inputs);
            
            $fileImage = $request->getFile('image_file');
            if(isset($fileImage)){
                $fileName = $fileImage->getClientName();
                if(isset($fileName) && !empty($fileName)){
                    FileHelper::deleteFile( $popupsItem->image_dir);
                    $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATH_UPLOAD_POPUP, $id);
                     $popupsItem->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                }
                
                $this->popupsModel->save($popupsItem);
            }

            $this->db->transComplete();
        }

    }

    public function deletePopups($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->popupsModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->popupsModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}