<?php
namespace App\Services;

use App\Entities\CartInfo;
use App\Entities\Productmp;
use App\Entities\ProductQuote;
use App\Entities\ProductQuoteDetail;
use App\Helpers\ArrayHelper;
use App\Helpers\DateHelper;
use App\Helpers\FileHelper;
use App\Models\ProductmpModel;
use App\Models\ProductQuoteDetailModel;
use CodeIgniter\HTTP\RequestInterface;
use League\Flysystem\Exception;
use phpDocumentor\Reflection\DocBlock\Tags\Throws;

class ProductmpService extends BaseService {

    public function saveProductListProduct(RequestInterface $request){

        try{
            $this->db->transBegin();
            $product = new Product();
            $inputs = $request->getPost();
            $product->fill($inputs);
            $product->updated_at = '';

            $manufactureId = $product->id;
            $manufacturer = $this->manufacturerModel->findById($manufactureId);
            $manufacturer_name = preg_replace("/\s+/", "", $manufacturer->name);
            $product->part_number_sequence = $product->api_code.$manufacturer_name.$product->part_number.$product->product_api_id;

            if ($product->qty > 0) {
                $product->qty_flag = '1';
            } else {
                $product->qty_flag = '0';
            }

            $vrpntem = "$product->part_number.$product->product_api_id.$product->product_code.$manufacturer_name";
            $str = preg_replace("/\s+/", "", $vrpntem);
            $vrpartnumber = str_replace(array("/", "-", "_", "[", "]", "(", ")", "."), '', $str);
            $product->virtualpn= $vrpartnumber;
            
            /*
            var_dump($product);
            var_dump($manufacturer_name);
            var_dump($product->api_code);
            var_dump($manufacturer->code);
            var_dump($product->part_number);
            var_dump($product->product_api_id);
            exit;
            */

            $insertId = $this->productmpModel->insert($product, true);
            
            if($insertId > 0){
                $productDb = $this->productmpModel->find($insertId);
                $fileImage = $request->getFile('image_file');
                $fileImage2 = $request->getFile('image2_file');
                $fileImage3 = $request->getFile('image3_file');
                $filePdf = $request->getFile('pdf_file');

                if(isset($fileImage) && !empty($fileImage->getClientName())){
                    $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                    $productDb->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                    $productDb->image_thumbnail_dir = $fileImagePath[FileHelper::IMAGE_THUMBNAIL_NAME];
                    $productDb->image_big_dir = $fileImagePath[FileHelper::IMAGE_BIG_NAME];
                    $this->productmpModel->save($productDb);
                }

                if(isset($fileImage2) && !empty($fileImage2->getClientName())){
                    $fileImage2Path = FileHelper::saveFile($fileImage2, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                    $productDb->image2_dir = $fileImage2Path;
                    $this->productmpModel->save($productDb);
                }
                
                if(isset($fileImage3) && !empty($fileImage3->getClientName())){
                    $fileImage3Path = FileHelper::saveFile($fileImage3, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                    $productDb->image3_dir = $fileImage3Path;
                    $this->productmpModel->save($productDb);
                }
                
                if(isset($filePdf) && !empty($filePdf->getClientName())){
                    $filePdfPath = FileHelper::saveFile($filePdf, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                    $productDb->pdf_dir = $filePdfPath;
                    $this->productmpModel->save($productDb);
                }

                // $this->productmpModel->save($productDb);

            }
            
            $this->db->transComplete();
            return true;

        } catch (\Throwable $ex) {
            
            $this->db->transRollback();
            throw $ex;
        }
    }

    public function uploadProductListProduct($id, RequestInterface $request){

        try{
            $this->db->transBegin();

            $product = $this->productmpModel->find($id);

            if(isset($product)){

                $inputs = $request->getPost();
                $product->fill($inputs);
                
                $newproduct_chk = $request->getPost('newproduct_chk');
                if ($newproduct_chk == '1') {
                    $product->newproduct_chk = '1';
                } else {
                    $product->newproduct_chk = '0';
                }

                $bestproduct_chk = $request->getPost('bestproduct_chk');
                if ($bestproduct_chk == '1') {
                    $product->bestproduct_chk = '1';
                } else {
                    $product->bestproduct_chk = '0';
                }

                $recomproduct_chk = $request->getPost('recomproduct_chk');
                if ($recomproduct_chk == '1') {
                    $product->recomproduct_chk = '1';
                } else {
                    $product->recomproduct_chk = '0';
                }

                $brandproduct_chk = $request->getPost('brandproduct_chk');
                if ($brandproduct_chk == '1') {
                    $product->brandproduct_chk = '1';
                } else {
                    $product->brandproduct_chk = '0';
                }

                $situation = $request->getPost('situation');
                if ($situation == '1') {
                    $product->situation = '1';
                } else {
                    $product->situation = '0';
                }

                $exposure = $request->getPost('exposure');
                if ($exposure == '1') {
                    $product->exposure = '1';
                } else {
                    $product->exposure = '0';
                }

                // var_dump( $product->newproduct_chk);
                // exit;

                $fileImage = $request->getFile('image_file');
                $fileImage2 = $request->getFile('image2_file');
                $fileImage3 = $request->getFile('image3_file');
                $filePdf = $request->getFile('pdf_file');

                if(isset($fileImage)){
                    $fileName = $fileImage->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        FileHelper::deleteFile($product->image_dir);
                        FileHelper::deleteFile($product->image_thumbnail_dir);
                        FileHelper::deleteFile($product->image_big_dir);
                        $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $product->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                        $product->image_thumbnail_dir = $fileImagePath[FileHelper::IMAGE_THUMBNAIL_NAME];
                        $product->image_big_dir = $fileImagePath[FileHelper::IMAGE_BIG_NAME];
                    }
                }
                
                if(isset($fileImage2)){
                    $fileName = $fileImage2->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        FileHelper::deleteFile($product->pdf_dir);
                        $fileImage2Path = FileHelper::saveFile($fileImage2, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $product->image2_dir = $fileImage2Path;
                        $this->productmpModel->save($product);
                    }
                }

                if(isset($fileImage3)){
                    $fileName = $fileImage3->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        FileHelper::deleteFile($product->pdf_dir);
                        $fileImage3Path = FileHelper::saveFile($fileImage3, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $product->image3_dir = $fileImage3Path;
                        $this->productmpModel->save($product);
                    }
                }

                if(isset($filePdf)){
                    $fileName = $filePdf->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        FileHelper::deleteFile($product->pdf_dir);
                        $filePdfPath = FileHelper::saveFile($filePdf, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $product->pdf_dir = $filePdfPath;
                        $this->productmpModel->save($product);
                    }
                }

                if ($product->partnum_seq_edit == 1) {
                    $manufactureId = $product->id;
                    $manufacturer = $this->manufacturerModel->findById($manufactureId);
                    $manufacturer_name = preg_replace("/\s+/", "", $manufacturer->name);
                    $product->part_number_sequence = $product->api_code.$manufacturer_name.$product->part_number.$product->product_api_id;
                }

                $this->productmpModel->save($product);

                //echo "Test";
                //exit;

                $this->db->transComplete();
            }

            return true;

        }catch (\Throwable $ex){
            $this->db->transRollback();
            throw $ex;
        }
    }

    public function deleteProductProduct($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $product = $this->productmpModel->find($id);
                    if(isset($product)){
                        $pathFolder = null;
                        if(isset($product->image_dir)) $pathFolder = pathinfo($product->image_dir, PATHINFO_DIRNAME);
                        if($pathFolder == null && isset($product->pdf_dir)) $pathFolder = pathinfo($product->pdf_dir, PATHINFO_DIRNAME);
                        FileHelper::deleteFile($product->image_dir);
                        FileHelper::deleteFile($product->pdf_dir);
                        if($pathFolder != null) FileHelper::deleteFile($pathFolder);
                        $fileHtml = FileHelper::FOLDER_PATH_UPLOAD.'/'.FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS.'/'.$id.'index.html';
                        FileHelper::deleteFile($fileHtml);
                        $this->productmpModel->delete($id);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

    public function deleteAllProductProduct(){
        ini_set('display_errors',1);
        try{
            $this->db->transBegin();
            $this->productmpModel->truncate();
            $pathFolder = FileHelper::FOLDER_PATH_UPLOAD.'/'.FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS;
            FileHelper::deleteFile($pathFolder);
            $this->db->transComplete();
            return true;
        }catch (\Throwable $ex){
            $this->db->transRollback();
            throw $ex;
        }
    }

    public function importProduct($inputs, $data, $headerColumns){
        ini_set('display_errors',1);
        $message = [
            'status' => 1,
            'error' => 'Format file incorrect'
        ];
        if(isset($data) && is_array($data) && count($data) > 0){
            $uploadType = $inputs['upload_type'];
            $columnManufacturer = 'id';
            $columnPartNumber = 'part_number';
            $columnProductId = 'product_id';
            $tableColumns = [];
            //Check header
            $headerData = $data[0];
            $sameColumnNum = 0;
            foreach ($headerColumns as $keyValue => $column){
                $columns = explode('|',$column);
                if(is_array($columns) && count($columns) > 0){
                    foreach ($columns as $columnProduct){
                        foreach ($headerData as $index => $header){
                            if(trim(strtolower($header)) == trim(strtolower($columnProduct))){
                                $tableColumns[$keyValue] = $index;
                                break;
                            }
                        }
                    }
                }
            }
            if(count($tableColumns) != count($headerColumns)) return $message;
            //Import data
            $dataInserts = [];
            $mapManufacturerNames = [];
            $mapPartNumber = [];
            $mapProductId = [];
            for($index = 1 ; $index < count($data) ; $index ++){
                $dataProducts = [];
                foreach ($tableColumns as $tableColumn => $indexData){
                    $dataProducts[$tableColumn] = $data[$index][$indexData];
                }
                if(!in_array($dataProducts[$columnManufacturer], $mapManufacturerNames)) $mapManufacturerNames[] = $dataProducts[$columnManufacturer];
                $mapPartNumber[] = $dataProducts[$columnPartNumber];
                if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType){
                    $mapProductId[] = $dataProducts[$columnProductId];
                }
                $dataInserts[] = $dataProducts;
            }
            $manufacturers = $this->manufacturerModel->findAllByName($mapManufacturerNames);
            $mapManufacturers = ArrayHelper::parseListObjectToArrayKey($manufacturers, 'name');
            $mapProducts = [];
            if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType){
                $productExits = $this->productmpModel->getByProductNo($mapProductId);
                $mapProducts = ArrayHelper::parseListObjectToArrayKey($productExits, $columnProductId);
            }
            //Insert Data To DB
            $countInsert = 0;
            $countUpdate = 0;

            foreach ($dataInserts as $dataInsert){
                $manufacturer = $mapManufacturers[$dataInsert[$columnManufacturer]];
                if(isset($manufacturer)){
                    if(EXCEL_UPLOAD_TYPE_ADDING == $uploadType){ //Mode add product

                            $product = new Product($dataInsert);
                            $product->maker_seq = $manufacturer->maker_seq;

                            $timestr = date(time());
                            $codestr = substr($timestr, 4);

                            $codecount = str_pad($countInsert, 6, "0", STR_PAD_LEFT);
                            //var_dump ($codecount);
                            //exit;

                            $product->product_code = "M".$codestr.$codecount;

                            $categorylevel1 = $this->categorylevel1Model->findByCategoryInfo($product->part_category);
                            // var_dump ($categorylevel1['categorylevel1_code']);
                            $product->part_category = $categorylevel1['categorylevel1_code'];

                            $categorylevel2 = $this->categorylevel2Model->findByCategoryInfo($product->part_category2);
                            // var_dump ($categorylevel2['categorylevel2_code']);
                            $product->part_category2 = $categorylevel2['categorylevel2_code'];

                            $categorylevel3 = $this->categorylevel3Model->findByCategoryInfo($product->part_category3);
                            // var_dump ($categorylevel3['categorylevel3_code']);
                            $product->part_category3 = $categorylevel3['categorylevel3_code'];
                            // exit;

                            // var_dump ($product);
                            // exit;
                            $this->productmpModel->save($product);
                            $countInsert++;

                    }else if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType){
                        $product = $mapProducts[$dataInsert[$columnProductId]];
                        if(isset($product)){
                            $product->qty = $dataInsert['qty'];
                            $this->productmpModel->save($product);
                            $countUpdate++;
                        }
                    }
                }
            }
            $message = 'Upload add success ' . $countInsert . ' records';
            if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType) { //Mode add product
                $message = 'Upload overwrite success ' . $countUpdate . ' records';
            }
            return [
                'status' => 0,
                'message' => $message
            ];
        }
        return $message;
    }

    public function saveInputSaveProduct($products){
        try{
            $this->db->transBegin();
            foreach ($products as $product){
                //Delete check duplicate
                //if($this->productmpModel->findByPartNumber($product['part_number'])) continue;
                $entityProduct = new Product();
                $entityProduct->fill($product);
                $this->productmpModel->save($entityProduct);
            }
            $this->db->transComplete();
        }catch (\Throwable $ex){
            $this->db->transRollback();
            throw $ex;
        }
    }
}