<?php
namespace App\Services;

use App\Entities\ReasonreturnInfo;
use App\Helpers\FileHelper;
use App\Models\ReasonreturnInfoModel;
use CodeIgniter\HTTP\RequestInterface;

class ReasonreturnInfoService extends BaseService {

    public function saveReasonreturnInfo(RequestInterface $request){
        $reasonreturninfo = new ReasonreturnInfo();
        $inputs = $request->getPost();
        $reasonreturninfo->fill($inputs);
        $insertId = $this->reasonreturnInfoModel->insert($reasonreturninfo, true);
    }

    public function updateReasonreturnInfo($return_id, RequestInterface $request){
        $reasonreturninfoItem = $this->reasonreturnInfoModel->find($return_id);
        if(isset($reasonreturninfoItem)){
            $inputs = $request->getPost();
            $reasonreturninfoItem->fill($inputs);

            $this->reasonreturnInfoModel->save($reasonreturninfoItem);
        }
    }

    public function deleteReasonreturnInfo($return_ids){
        if(isset($return_ids)){
            try{
                $this->db->transBegin();
                foreach ($return_ids as $return_id){
                    $item = $this->reasonreturnInfoModel->find($return_id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->reasonreturnInfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}