<?php
namespace App\Services;

use App\Entities\ShippingCompany;
use App\Helpers\FileHelper;
use App\Models\ShippingCompanyModel;
use CodeIgniter\HTTP\RequestInterface;

class ShippingCompanyService extends BaseService {

    public function saveShippingCompany(RequestInterface $request){
        $shippingcompany = new ShippingCompany();
        $inputs = $request->getPost();
        $shippingcompany->fill($inputs);
        $insertId = $this->shippingCompanyModel->insert($shippingcompany, true);
    }

    public function updateShippingCompany($shipping_id, RequestInterface $request){
        $shippingcompanyItem = $this->shippingCompanyModel->find($shipping_id);
        if(isset($shippingcompanyItem)){
            $inputs = $request->getPost();
            // $inputs['active_flg'] = get_active_id($inputs['active_flg']);
            $shippingcompanyItem->fill($inputs);

            $this->shippingCompanyModel->save($shippingcompanyItem);
        }
    }

    public function deleteShippingCompany($shipping_ids){
        if(isset($shipping_ids)){
            try{
                $this->db->transBegin();
                foreach ($shipping_ids as $shipping_id){
                    $item = $this->shippingCompanyModel->find($shipping_id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->shippingCompanyModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}