<?php
namespace App\Services;

use App\Entities\StocklocationCategory;
use App\Helpers\FileHelper;
use App\Models\StocklocationCategoryModel;
use CodeIgniter\HTTP\RequestInterface;

class StocklocationCategorysService extends BaseService {

    public function saveStocklocationCategory(RequestInterface $request){
        $stocklocationcategorys = new StocklocationCategory();
        $inputs = $request->getPost();
        $stocklocationcategorys->fill($inputs);
        $insertId = $this->stocklocationCategorysModel->insert($stocklocationcategorys, true);
    }

    public function updateStocklocationCategory($location_id, RequestInterface $request){
        $stocklocationcategorysItem = $this->stocklocationCategorysModel->find($location_id);
        if(isset($stocklocationcategorysItem)){
            $inputs = $request->getPost();
            $stocklocationcategorysItem->fill($inputs);

            $this->stocklocationCategorysModel->save($stocklocationcategorysItem);
        }
    }

    public function deleteStocklocationCategory($location_ids){
        if(isset($location_ids)){
            try{
                $this->db->transBegin();
                foreach ($location_ids as $location_id){
                    $item = $this->stocklocationCategorysModel->find($location_id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->stocklocationCategorysModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}