<?php
namespace App\Services;

use App\Entities\Todaystat;
use App\Helpers\FileHelper;
use App\Models\TodaystatModel;
use CodeIgniter\HTTP\RequestInterface;

class TodaystatService extends BaseService {

    public function saveTodaystat(RequestInterface $request){
        //Save todaystat
        $todaystat = new Todaystat();
        $inputs = $request->getPost();
        $todaystat->fill($inputs);
        $insertId = $this->todaystatModel->insert($todaystat, true);
    }

    public function updateTodaystat($id, RequestInterface $request){
        $todaystatItem = $this->todaystatModel->find($id);
        if(isset($todaystatItem)){
            $inputs = $request->getPost();
            $todaystatItem->fill($inputs);
            $this->todaystatModel->save($todaystatItem);
        }
    }

    public function deleteTodaystat($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->todaystatModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->todaystatModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}