<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_bannerinfos('update_bannerinfos')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>

    <script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
    <script src="<?=asset_admin_js('advanced-forms.js')?>"></script>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        .date{width: 10%}
        .quote_no{width: 10%}
        .amount{width: 10%}
        .name{width: 15%}
        .email{width: 15%}
        .action{width: 10%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
        a.disabled {
            pointer-events: none;
            cursor: default;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.bannerinfos.update')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('bannerinfos.update',$item->id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                                <div class="card-header">
                                    <i class="fa fa-edit"></i> <?=lang_bannerinfos('update_bannerinfos')?>
                                    <div class="card-header-actions float-right">
                                        <a class="btn btn-block btn-secondary" href="<?=route_admin('bannerinfos.index')?>">
                                            <?=lang_common('back')?>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_bannerinfos('category')?>
                                        </label>
                                        <div class="col-md-6">
                                            <select class="form-control" name="category_id">
                                                <?php foreach ($categories as $category): ?>
                                                    <option value="<?=$category->category_id?>" <?php if($item->category_id == $category->category_id) echo 'selected' ?>>
                                                        <?=$category->category_name?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>

                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_bannerinfos('accept')?>
                                        </label>
                                        <div class="col-md-2">
                                            <input type="checkbox" name="active_flg" <?php if($item->active_flg == MEMBER_ACCEPT_ON) echo 'checked' ?> data-bootstrap-switch>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_bannerinfos('title')?>
                                            <span class="color-red">*</span>
                                        </label>
                                        <div class="col-md-10">
                                            <input class="form-control" value="<?=old_value('title',$item->title)?>" id="text-input" type="text" name="title" placeholder="<?=lang_bannerinfos('title')?>" required>
                                        </div>
                                    </div>
                                                            
                                    <?php
                                            if ($item->start_date){
                                                $from_date = $item->start_date;
                                            }

                                            if ($item->end_date){
                                                $to_date = $item->end_date;
                                            }
                                    ?>

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_bannerinfos('dates')?>
                                            </label>
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('start_date')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-3">
                                                <input class="form-control date-single" value="<?=$from_date?>" id="text-input" type="text" name="start_date" placeholder="<?=lang_common('start_date')?>">
  
                                            </div>

                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('end_date')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-3">
                                                <input class="form-control date-single" value="<?=$to_date?>" id="text-input" type="text" name="end_date" placeholder="<?=lang_common('end_date')?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                                <label class="col-md-2 col-form-label" for="text-input">
                                                    <?=lang_common('goto_URL')?>
                                                    <span class="color-red">*</span>
                                                </label>
                                                <div class="col-md-6">
                                                    <input class="form-control" value="<?=old_value('goto_URL',$item->goto_URL)?>" id="text-input" type="text" name="goto_URL" placeholder="<?=lang_common('goto_URL')?>">
                                                </div>

                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('goto_type_title')?>
                                                <span class="color-red">*</span>
                                            </label>

                                            <div class="col-md-2">
                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="goto_type" type="radio" value="<?=DISPLAY_STATUS_ON?>" id="goto_type_1" <?php if($item->goto_type == DISPLAY_STATUS_ON) echo 'checked' ?>>
                                                        <label class="form-check-label" for="goto_type_1"><?=lang_common('goto_type_1')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="goto_type" type="radio" value="<?=DISPLAY_STATUS_OFF?>" id="goto_type_2" <?php if($item->goto_type == DISPLAY_STATUS_OFF) echo 'checked' ?>>
                                                        <label class="form-check-label" for="goto_type_2"><?=lang_common('goto_type_2')?></label>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>    

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label">
                                                <?=lang_common('image_file')?>
                                            </label>
                                            <div class="col-md-10">
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" id="image_file" name="image_file" maxsizeMb="10" accept="image/*">
                                                        <label class="custom-file-label" for="image_file"> <?=show_text_dot($item->image_dir,50)?></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <!--<div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('public')?>
                                        </label>
                                        <div class="col-md-10">
                                            <input type="checkbox" name="public_flg" <?=public_check_input($item->public_flg)?> data-bootstrap-switch>
                                        </div>
                                    </div>-->
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_bannerinfos('sub_title')?>
                                            <span class="color-red">*</span>
                                        </label>
                                        <div class="col-md-10">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <textarea class="form-control" id="summary-ckeditor" name="sub_title" rows="2"><?=esc(old_value('sub_title',$item->sub_title))?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                        <?=lang_bannerinfos('imgview')?>
                                        </label>
                                        <div class="col-md-10">
                                            <div class="row">
                                                <div class="col-md-12">
                                                <?php if($item->category_id == 5) { ?>
                                                <img src="<?=asset_public($item->image_dir)?>" alt="<?=$item->title?>" style="width:800px;">
                                                <?php } else { ?>
                                                <img src="<?=asset_public($item->image_dir)?>" alt="<?=$item->title?>">
                                                <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
