<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_buyerinfo('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        .date{width: 10%}
        .quote_no{width: 10%}
        .amount{width: 10%}
        .name{width: 15%}
        .email{width: 15%}
        .action{width: 10%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
        a.disabled {
            pointer-events: none;
            cursor: default;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('sale-quote.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
    <script src="<?=asset_admin_js('advanced-forms.js')?>"></script>

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.buyerinfo')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_buyerinfo('list_title')?>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>
                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? 'show' : ''?>" id="collapseSearch">
                                <div class="card card-body">

                                    <form action="<?=route_admin('buyerinfo.index')?>" method="get">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group row pl-2">
                                                    <label class="col-form-label pl-3" for="date-input">
                                                        <?=lang_common('name')?> :
                                                    </label>
                                                    <div class="pl-2 col-md-4">
                                                        <input class="form-control" value="<?="$keyword"?>" type="text" name="keyword">
                                                    </div>
                                                    <div class="pl-3">
                                                        <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                            <i class="fa fa-search" aria-hidden="true"></i>
                                                            <?=lang_common('search')?>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                                </div>
                            </div>
                            
                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <?php if(count($lists) > 0): ?>
                                    <!-- Header Delete-->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <!--th class="text-center checkbox">
                                            </th-->
                                            <th class="amount" >
                                                <?=lang_common('code')?>
                                            </th>
                                            <th class="amount" >
                                                <?=lang_member('email')?>
                                            </th>
                                            <th class="name" >
                                                <?=lang_common('name')?>
                                            </th>
                                            <th class="date">
                                                <?=lang_common('insert_date')?>
                                            </th>
                                            <th class="action">
                                                <?=lang_common('detail')?>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $item): ?>
                                            <tr role="row" class="odd">
                                                <!--td class="text-center">
                                                    <?=$item->member_id?>
                                                </td-->
                                                <td class="text-center">
                                                    <?=$item->member_code?>
                                                </td>
                                                <td class="text-center">
                                                    <?=$item->member_email?>
                                                </td>
                                                <td class="text-center">
                                                    <?=$item->member_name?>
                                                </td>
                                                <td class="text-center">
                                                    <?=$item->created_at?>
                                                </td>
                                                <td class="text-center">
                                                    <a class="btn btn-success" title="<?=lang_common('detail')?>" href="<?=route_admin('buyerinfo.detail',$item->member_id)?>" data-toggle="tooltip" data-original-title="Detail">
                                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                        <tr>
                                            <td colspan="7">
                                                <?=lang_common('no_data')?>
                                            </td>
                                        </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-12 text-right">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>