<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_category3('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('sale-quote.js')?>"></script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.category3')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_category3('list_title')?>
                        <div class="card-header-actions float-right">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('category3.show_create')?>">
                                <?=lang_common('create')?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>
                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? 'show' : ''?>" id="collapseSearch">
                                    <form action="<?=route_admin('category3.index')?>" method="get">
                                        <div class="card card-body">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group row pl-2">
                                                        <label class="col-form-label pl-3" for="category3_name">
                                                            <?=lang_common('name')?> :
                                                        </label>
                                                        <div class="pl-2 col-md-4">
                                                            <input class="form-control" value="<?=$category3_name?>" type="text" name="category3_name">
                                                        </div>
                                                        <div class="pl-3">
                                                            <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                                <i class="fa fa-search" aria-hidden="true"></i>
                                                                <?=lang_common('search')?>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <th class="text-center checkbox">
                                                <input type="checkbox" name="check_all">
                                            </th>
                                            <th class="sorting_asc">
                                                <?=lang_common('no')?>
                                            </th>
                                            <th class="sorting">
                                                <?=lang_category3('code')?>
                                            </th>
                                            <th class="sorting app-col-name" >
                                                <?=lang_category3('name')?>
                                            </th>
                                            <th class="sorting app-col-price" >
                                                <?=lang_category3('name_eng')?>
                                            </th>
                                            <th class="sorting app-col-type" >
                                                <?=lang_common('insert_date')?>
                                            </th>
                                            <th class="sorting app-col-action">
                                                <?=lang_common('action')?>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $item): ?>
                                            <? #var_dump($lists); ?>
                                            <? #var_dump($key); ?>
                                            <? #var_dump($item); ?>
                                            <tr role="row" class="odd">
                                                <td class="text-center">
                                                    <input type="checkbox" name="check_box" value="<?=$item->category3_id?>">
                                                </td>
                                                <td class="text-right">
                                                    <?=show_no_row($key+1, $perPage, $currentPage)?>
                                                </td>
                                                <td>
                                                <?=$item->category3_id?>
                                                </td>
                                                <td >
                                                    <?=$item->category3_name?>
                                                </td>
                                                <td class="">
                                                    <?=$item->category3_name_eng?>
                                                </td>
                                                <td class="">
                                                    <?=\App\Helpers\DateHelper::toTimeString($item->created_at)?>
                                                </td>
                                                </td>
                                                <td class="text-center">
                                                    <a class="btn btn-info" title="<?=lang_common('detail')?>" href="<?=route_admin('category3.show_update',$item->category3_id)?>">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                            <tr>
                                                <td colspan="8">
                                                    <?=lang_common('no_data')?>
                                                </td>
                                            </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-3">
                                            <a data-toggle="modal" class="btn btn-danger anchorClick delete"
                                               data-url="<?=route_admin('category3.delete','')?>"
                                               data-url-origin="<?=route_admin('category3.delete','')?>"
                                               data-name="<?=lang_category3('title')?>" href="#deleteModal">
                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                <?=lang_common('delete')?>
                                            </a>
                                        </div>
                                        <div class="col-md-9">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
