<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_categorylevel('categorylevel1update')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">
    <style>
        input[readonly] { /* For Firefox */
            background-color: #ffffff !important;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('categorylevel2', $(this).prop('checked'));
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.categorylevel.update')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('categorylevel.updateindex1', $item->categorylevel1_id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                            <div class="card-header">
                                <i class="fa fa-edit"></i> <?=lang_categorylevel('categorylevel1update')?>
                                <div class="card-header-actions float-right">
                                    <a class="btn btn-block btn-secondary" href="<?=route_admin('categorylevel.categorylevel1list')?>">
                                        <?=lang_common('back')?>
                                    </a>
                                </div>
                            </div>

                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <input type="hidden" name="categorylevel1_code" value="<?=$item->categorylevel1_code?>">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text width-100">
                                                        <?=lang_categorylevel('name')?>
                                                        </span>
                                                    </div>
                                                    <input class="form-control" id="categorylevel1_name" type="text" name="categorylevel1_name" value="<?=$item->categorylevel1_name?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text width-100">
                                                        <?=lang_categorylevel('name_eng')?>
                                                        </span>
                                                    </div>
                                                    <input class="form-control" id="categorylevel1_name_eng" type="text" name="categorylevel1_name_eng" value="<?=$item->categorylevel1_name_eng?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                <div class="card-footer text-center">
                                    <button type="submit" class="btn bg-gradient-primary pl-3 pr-3"><?=lang_common('update')?></button>
                                </div>

                            </div>
                            </form>

                        </div>
                    </div>

                </div>                
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
