<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_categorylevel('categorylevel2update')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">
    <style>
        input[readonly] { /* For Firefox */
            background-color: #ffffff !important;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('categorylevel2', $(this).prop('checked'));
        });
    </script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>

    <script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
    <script src="<?=asset_admin_js('advanced-forms.js')?>"></script>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        .date{width: 10%}
        .quote_no{width: 10%}
        .amount{width: 10%}
        .name{width: 15%}
        .email{width: 15%}
        .action{width: 10%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
        a.disabled {
            pointer-events: none;
            cursor: default;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?=$breadcrumb->render('admin.categorylevel.update')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('categorylevel.updateindex2', $item->categorylevel2_id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                            <div class="card-header">
                                <i class="fa fa-edit"></i> <?=lang_categorylevel('categorylevel2update')?>
                                <div class="card-header-actions float-right">
                                    <a class="btn btn-block btn-secondary" href="<?=route_admin('categorylevel.categorylevel2list')?>">
                                        <?=lang_common('back')?>
                                    </a>
                                </div>
                            </div>

                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_categorylevel('name')?>1</span>
                                                    </div>
                                                    <select name="categorylevel1_id" id="categorylevel1" class="form-control input-lg">
                                                        <?php
                                                        foreach($categorylevel1 as $row) {
                                                            if ($item->categorylevel1_id == $row["categorylevel1_id"] ) {
                                                                echo '<option value="'.$row["categorylevel1_id"].'" selected>'.$row["categorylevel1_name"].'</option>';
                                                            }else{
                                                                echo '<option value="'.$row["categorylevel1_id"].'">'.$row["categorylevel1_name"].'</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <input type="hidden" name="categorylevel2_code" value="<?=$item->categorylevel2_code?>">
                                            <div class="form-group row">
                                                <div class="input-group col-md-6">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100">한)카테고리2명</span>
                                                    </div>
                                                    <input class="form-control" id="categorylevel2_name" type="text" name="categorylevel2_name" value="<?=$item->categorylevel2_name?>">
                                                </div>
                                                <div class="input-group col-md-6">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100">영)카테고리2명</span>
                                                    </div>
                                                    <input class="form-control" id="categorylevel2_name_eng" type="text" name="categorylevel2_name_eng" value="<?=$item->categorylevel2_name_eng?>">
                                                </div>
                                            </div>                                            
                                        </div>                                
                                    </div>

                                    <div class="card-footer text-center">
                                        <button type="submit" class="btn bg-gradient-primary pl-3 pr-3"><?=lang_common('update')?></button>
                                    </div>

                                </div>
                            </form>

                        </div>
                    </div>

                </div>                
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
